/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.beans.ConstructorProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.DefaultPersistentPropertyPath;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mapping.model.ClassGeneratingPropertyAccessorFactory;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.Pair;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMappingContext<E extends MutablePersistentEntity<?, P>, P extends PersistentProperty<P>>
implements MappingContext<E, P>,
ApplicationEventPublisherAware,
InitializingBean {
    private final Optional<E> NONE = Optional.empty();
    private final Map<TypeInformation<?>, Optional<E>> persistentEntities = new HashMap();
    private final PersistentPropertyAccessorFactory persistentPropertyAccessorFactory = new ClassGeneratingPropertyAccessorFactory();
    private ApplicationEventPublisher applicationEventPublisher;
    private Set<? extends Class<?>> initialEntitySet = new HashSet();
    private boolean strict = false;
    private SimpleTypeHolder simpleTypeHolder = SimpleTypeHolder.DEFAULT;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setInitialEntitySet(Set<? extends Class<?>> initialEntitySet) {
        this.initialEntitySet = initialEntitySet;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSimpleTypeHolder(SimpleTypeHolder simpleTypes) {
        Assert.notNull((Object)simpleTypes, (String)"SimpleTypeHolder must not be null!");
        this.simpleTypeHolder = simpleTypes;
    }

    @Override
    public Collection<E> getPersistentEntities() {
        try {
            this.read.lock();
            Collection collection = this.persistentEntities.values().stream().flatMap(xva$0 -> Optionals.toStream(xva$0)).collect(Collectors.toSet());
            return collection;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public Optional<E> getPersistentEntity(Class<?> type) {
        return this.getPersistentEntity((P)ClassTypeInformation.from(type));
    }

    @Override
    public E getRequiredPersistentEntity(Class<?> type) {
        return (E)((MutablePersistentEntity)this.getPersistentEntity((P)type).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't find PersistentEntity for type %s!", type))));
    }

    @Override
    public boolean hasPersistentEntityFor(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return this.persistentEntities.containsKey(ClassTypeInformation.from(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<E> getPersistentEntity(TypeInformation<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        try {
            this.read.lock();
            Optional<E> entity = this.persistentEntities.get(type);
            if (entity != null) {
                Optional<E> optional = entity;
                return optional;
            }
        }
        finally {
            this.read.unlock();
        }
        if (!this.shouldCreatePersistentEntityFor(type)) {
            try {
                this.write.lock();
                this.persistentEntities.put(type, this.NONE);
            }
            finally {
                this.write.unlock();
            }
            return this.NONE;
        }
        if (this.strict) {
            throw new MappingException("Unknown persistent entity " + type);
        }
        return this.addPersistentEntity(type);
    }

    @Override
    public E getRequiredPersistentEntity(TypeInformation<?> type) {
        return (E)((MutablePersistentEntity)this.getPersistentEntity((P)type).orElseThrow(() -> new MappingException(String.format("Couldn't find PersistentEntity for type %s!", type))));
    }

    @Override
    public Optional<E> getPersistentEntity(P persistentProperty) {
        Assert.notNull(persistentProperty, (String)"PersistentProperty must not be null!");
        TypeInformation<?> typeInfo = persistentProperty.getTypeInformation();
        return this.getPersistentEntity((P)typeInfo.getActualType());
    }

    @Override
    public E getRequiredPersistentEntity(P persistentProperty) {
        return (E)((MutablePersistentEntity)this.getPersistentEntity(persistentProperty).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't find PersistentEntity for type %s!", persistentProperty))));
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(PropertyPath propertyPath) {
        Assert.notNull((Object)propertyPath, (String)"Property path must not be null!");
        return this.getPersistentPropertyPath(propertyPath.toDotPath(), propertyPath.getOwningType());
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(String propertyPath, Class<?> type) {
        Assert.notNull((Object)propertyPath, (String)"Property path must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        return this.getPersistentPropertyPath(propertyPath, ClassTypeInformation.from(type));
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(InvalidPersistentPropertyPath invalidPath) {
        return this.getPersistentPropertyPath(invalidPath.getResolvedPath(), invalidPath.getType());
    }

    @Override
    private PersistentPropertyPath<P> getPersistentPropertyPath(String propertyPath, TypeInformation<?> type) {
        return this.getPersistentPropertyPath(Arrays.asList(propertyPath.split("\\.")), type);
    }

    private PersistentPropertyPath<P> getPersistentPropertyPath(Collection<String> parts, TypeInformation<?> type) {
        DefaultPersistentPropertyPath path = DefaultPersistentPropertyPath.empty();
        Iterator<String> iterator = parts.iterator();
        PersistentEntity current = this.getRequiredPersistentEntity((TypeInformation)type);
        while (iterator.hasNext()) {
            String segment = iterator.next();
            DefaultPersistentPropertyPath foo = path;
            PersistentEntity bar = current;
            Pair pair = this.getPair(path, iterator, segment, current).orElseThrow(() -> AbstractMappingContext.lambda$getPersistentPropertyPath$4(parts, foo, type, segment, (MutablePersistentEntity)bar));
            path = pair.getFirst();
            current = (MutablePersistentEntity)pair.getSecond();
        }
        return path;
    }

    private Optional<Pair<DefaultPersistentPropertyPath<P>, E>> getPair(DefaultPersistentPropertyPath<P> path, Iterator<String> iterator, String segment, E entity) {
        Optional persistentProperty = entity.getPersistentProperty(segment);
        return persistentProperty.map(it -> {
            TypeInformation<?> type = it.getTypeInformation().getActualType();
            return Pair.of(path.append(it), iterator.hasNext() ? this.getRequiredPersistentEntity((TypeInformation)type) : entity);
        });
    }

    protected Optional<E> addPersistentEntity(Class<?> type) {
        return this.addPersistentEntity(ClassTypeInformation.from(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<E> addPersistentEntity(TypeInformation<?> typeInformation) {
        Assert.notNull(typeInformation, (String)"TypeInformation must not be null!");
        try {
            this.read.lock();
            Optional<E> persistentEntity = this.persistentEntities.get(typeInformation);
            if (persistentEntity != null) {
                Optional<E> optional = persistentEntity;
                return optional;
            }
        }
        finally {
            this.read.unlock();
        }
        Class<?> type = typeInformation.getType();
        try {
            this.write.lock();
            E entity = this.createPersistentEntity(typeInformation);
            this.persistentEntities.put(typeInformation, Optional.of(entity));
            PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(type);
            HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor descriptor : pds) {
                descriptors.put(descriptor.getName(), descriptor);
            }
            try {
                PersistentPropertyCreator persistentPropertyCreator = new PersistentPropertyCreator(this, entity, descriptors);
                ReflectionUtils.doWithFields(type, (ReflectionUtils.FieldCallback)persistentPropertyCreator, (ReflectionUtils.FieldFilter)PersistentPropertyFilter.INSTANCE);
                persistentPropertyCreator.addPropertiesForRemainingDescriptors();
                entity.verify();
                if (this.persistentPropertyAccessorFactory.isSupported((PersistentEntity<?, ?>)entity)) {
                    entity.setPersistentPropertyAccessorFactory(this.persistentPropertyAccessorFactory);
                }
            }
            catch (MappingException mappingException) {
                this.persistentEntities.remove(typeInformation);
                throw mappingException;
            }
            if (null != this.applicationEventPublisher) {
                this.applicationEventPublisher.publishEvent(new MappingContextEvent(this, entity));
            }
            Optional<E> optional = Optional.of(entity);
            return optional;
        }
        catch (BeansException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Collection<TypeInformation<?>> getManagedTypes() {
        try {
            this.read.lock();
            Set<TypeInformation<?>> set = Collections.unmodifiableSet(new HashSet(this.persistentEntities.keySet()));
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    protected abstract <T> E createPersistentEntity(TypeInformation<T> var1);

    protected abstract P createPersistentProperty(Property var1, E var2, SimpleTypeHolder var3);

    public void afterPropertiesSet() {
        this.initialize();
    }

    public void initialize() {
        this.initialEntitySet.forEach(this::addPersistentEntity);
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        return !this.simpleTypeHolder.isSimpleType(type.getType());
    }

    private static /* synthetic */ InvalidPersistentPropertyPath lambda$getPersistentPropertyPath$4(Collection parts, DefaultPersistentPropertyPath foo, TypeInformation type, String segment, MutablePersistentEntity bar) {
        String source = StringUtils.collectionToDelimitedString((Collection)parts, (String)".");
        String resolvedPath = foo.toDotPath();
        return new InvalidPersistentPropertyPath(source, type, segment, resolvedPath, String.format("No property %s found on %s!", segment, bar.getName()));
    }

    static enum PersistentPropertyFilter implements ReflectionUtils.FieldFilter
    {
        INSTANCE;

        private static final Streamable<PropertyMatch> UNMAPPED_PROPERTIES;

        public boolean matches(Field field) {
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            return !UNMAPPED_PROPERTIES.stream().anyMatch(it -> it.matches(field.getName(), field.getType()));
        }

        public boolean matches(Property property) {
            Assert.notNull((Object)property, (String)"Property must not be null!");
            if (!property.hasAccessor()) {
                return false;
            }
            return !UNMAPPED_PROPERTIES.stream().anyMatch(it -> it.matches(property.getName(), property.getType()));
        }

        static {
            HashSet<PropertyMatch> matches = new HashSet<PropertyMatch>();
            matches.add(new PropertyMatch("class", null));
            matches.add(new PropertyMatch("this\\$.*", null));
            matches.add(new PropertyMatch("metaClass", "groovy.lang.MetaClass"));
            UNMAPPED_PROPERTIES = Streamable.of(matches);
        }

        static class PropertyMatch {
            private final String namePattern;
            private final String typeName;

            public PropertyMatch(String namePattern, String typeName) {
                Assert.isTrue((namePattern != null || typeName != null ? 1 : 0) != 0, (String)"Either name patter or type name must be given!");
                this.namePattern = namePattern;
                this.typeName = typeName;
            }

            public boolean matches(String name, Class<?> type) {
                if (this.namePattern != null && !name.matches(this.namePattern)) {
                    return false;
                }
                return this.typeName == null || type.getName().equals(this.typeName);
            }
        }
    }

    private static final class PersistentPropertyCreator
    implements ReflectionUtils.FieldCallback {
        @NonNull
        private final E entity;
        @NonNull
        private final Map<String, PropertyDescriptor> descriptors;
        @NonNull
        private final Map<String, PropertyDescriptor> remainingDescriptors;
        final /* synthetic */ AbstractMappingContext this$0;

        public PersistentPropertyCreator(E entity, Map<String, PropertyDescriptor> descriptors) {
            this(var1_1, (MutablePersistentEntity)entity, descriptors, descriptors);
        }

        public void doWith(Field field) {
            String fieldName = field.getName();
            ReflectionUtils.makeAccessible((Field)field);
            Property property = Optional.ofNullable(this.descriptors.get(fieldName)).map(it -> Property.of(field, it)).orElseGet(() -> Property.of(field));
            this.createAndRegisterProperty(property);
            this.remainingDescriptors.remove(fieldName);
        }

        public void addPropertiesForRemainingDescriptors() {
            this.remainingDescriptors.values().stream().map(Property::of).filter(PersistentPropertyFilter.INSTANCE::matches).forEach(this::createAndRegisterProperty);
        }

        private void createAndRegisterProperty(Property input) {
            Object property = this.this$0.createPersistentProperty(input, this.entity, this.this$0.simpleTypeHolder);
            if (property.isTransient()) {
                return;
            }
            if (!input.isFieldBacked() && !property.usePropertyAccess()) {
                return;
            }
            this.entity.addPersistentProperty(property);
            property.getAssociation().ifPresent(arg_0 -> this.entity.addAssociation(arg_0));
            if (this.entity.getType().equals(property.getRawType())) {
                return;
            }
            property.getPersistentEntityType().forEach(this.this$0::addPersistentEntity);
        }

        @ConstructorProperties(value={"entity", "descriptors", "remainingDescriptors"})
        private PersistentPropertyCreator(@NonNull E entity, @NonNull Map<String, PropertyDescriptor> descriptors, Map<String, PropertyDescriptor> remainingDescriptors) {
            this.this$0 = var1_1;
            if (entity == null) {
                throw new IllegalArgumentException("entity is null");
            }
            if (descriptors == null) {
                throw new IllegalArgumentException("descriptors is null");
            }
            if (remainingDescriptors == null) {
                throw new IllegalArgumentException("remainingDescriptors is null");
            }
            this.entity = entity;
            this.descriptors = descriptors;
            this.remainingDescriptors = remainingDescriptors;
        }
    }
}

