/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.data.annotation.Reference;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractPersistentProperty<P extends PersistentProperty<P>>
implements PersistentProperty<P> {
    private static final Field CAUSE_FIELD = ReflectionUtils.findField(Throwable.class, (String)"cause");
    private final String name;
    private final TypeInformation<?> information;
    private final Class<?> rawType;
    private final Lazy<Optional<Association<P>>> association;
    private final PersistentEntity<?, P> owner;
    private final Property property;
    private final Lazy<Integer> hashCode;
    private final Lazy<Boolean> usePropertyAccess;
    private final Lazy<Optional<? extends TypeInformation<?>>> entityTypeInformation;

    public AbstractPersistentProperty(Property property, PersistentEntity<?, P> owner, SimpleTypeHolder simpleTypeHolder) {
        Assert.notNull((Object)simpleTypeHolder, (String)"SimpleTypeHolder must not be null!");
        Assert.notNull(owner, (String)"Owner entity must not be null!");
        this.name = property.getName();
        this.rawType = property.getType();
        this.information = PropertyPath.from(Pattern.quote(property.getName()), owner.getTypeInformation()).getTypeInformation();
        this.property = property;
        this.association = Lazy.of(() -> this.isAssociation() ? Optional.of(this.createAssociation()) : Optional.empty());
        this.owner = owner;
        this.hashCode = Lazy.of(property::hashCode);
        this.usePropertyAccess = Lazy.of(() -> owner.getType().isInterface() || this.getField().map(it -> it.equals(CAUSE_FIELD)).orElse(false) != false);
        this.entityTypeInformation = Lazy.of(() -> Optional.ofNullable(this.information.getActualType()).filter(it -> !simpleTypeHolder.isSimpleType(it.getType())).filter(it -> !it.isCollectionLike()).filter(it -> !it.isMap()));
    }

    protected abstract Association<P> createAssociation();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.information.getType();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public TypeInformation<?> getTypeInformation() {
        return this.information;
    }

    @Override
    public Iterable<? extends TypeInformation<?>> getPersistentEntityType() {
        if (!this.isEntity()) {
            return Collections.emptySet();
        }
        return this.entityTypeInformation.get().map(it -> Collections.singleton(it)).orElseGet(() -> Collections.emptySet());
    }

    @Override
    public Optional<Method> getGetter() {
        return this.property.getGetter();
    }

    @Override
    public Optional<Method> getSetter() {
        return this.property.getSetter();
    }

    @Override
    public Optional<Field> getField() {
        return this.property.getField();
    }

    @Override
    public Optional<String> getSpelExpression() {
        return Optional.empty();
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return !this.isTransient();
    }

    @Override
    public boolean isAssociation() {
        return this.isAnnotationPresent(Reference.class);
    }

    @Override
    public Optional<Association<P>> getAssociation() {
        return this.association.get();
    }

    @Override
    public boolean isCollectionLike() {
        return this.information.isCollectionLike();
    }

    @Override
    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    @Override
    public boolean isEntity() {
        return !this.isTransient() && this.entityTypeInformation.get().isPresent();
    }

    @Override
    public Optional<Class<?>> getComponentType() {
        if (!this.isMap() && !this.isCollectionLike()) {
            return Optional.empty();
        }
        return Optional.of(this.information.getRequiredComponentType().getType());
    }

    @Override
    public Optional<Class<?>> getMapValueType() {
        return this.isMap() ? this.information.getMapValueType().map(TypeInformation::getType) : Optional.empty();
    }

    @Override
    public Class<?> getActualType() {
        return this.information.getActualType().getType();
    }

    @Override
    public boolean usePropertyAccess() {
        return this.usePropertyAccess.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractPersistentProperty)) {
            return false;
        }
        AbstractPersistentProperty that = (AbstractPersistentProperty)obj;
        return this.property.equals(that.property);
    }

    public int hashCode() {
        return this.hashCode.get();
    }

    public String toString() {
        return this.property.toString();
    }

    @Override
    public PersistentEntity<?, P> getOwner() {
        return this.owner;
    }

    protected Property getProperty() {
        return this.property;
    }
}

