/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.annotation.AccessType;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.annotation.Reference;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Version;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AbstractPersistentProperty;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Optionals;
import org.springframework.util.Assert;

public abstract class AnnotationBasedPersistentProperty<P extends PersistentProperty<P>>
extends AbstractPersistentProperty<P> {
    private static final String SPRING_DATA_PACKAGE = "org.springframework.data";
    private final Optional<Value> value;
    private final Map<Class<? extends Annotation>, Optional<? extends Annotation>> annotationCache = new HashMap<Class<? extends Annotation>, Optional<? extends Annotation>>();
    private final Lazy<Boolean> usePropertyAccess = Lazy.of(() -> this.findPropertyOrOwnerAnnotation(AccessType.class).map(it -> AccessType.Type.PROPERTY.equals((Object)it.value())).orElse(super.usePropertyAccess()));
    private final Lazy<Boolean> isTransient = Lazy.of(() -> super.isTransient() || this.isAnnotationPresent(Transient.class) || this.isAnnotationPresent(Value.class) || this.isAnnotationPresent(Autowired.class));

    public AnnotationBasedPersistentProperty(Property property, PersistentEntity<?, P> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        this.populateAnnotationCache(property);
        this.value = this.findAnnotation(Value.class);
    }

    private void populateAnnotationCache(Property property) {
        Optionals.toStream(property.getGetter(), property.getSetter()).forEach(it -> {
            for (Annotation annotation : it.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                this.validateAnnotation(annotation, "Ambiguous mapping! Annotation %s configured multiple times on accessor methods of property %s in class %s!", annotationType.getSimpleName(), this.getName(), this.getOwner().getType().getSimpleName());
                this.annotationCache.put(annotationType, Optional.of(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)it, annotationType)));
            }
        });
        property.getField().ifPresent(it -> {
            for (Annotation annotation : it.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                this.validateAnnotation(annotation, "Ambiguous mapping! Annotation %s configured on field %s and one of its accessor methods in class %s!", annotationType.getSimpleName(), it.getName(), this.getOwner().getType().getSimpleName());
                this.annotationCache.put(annotationType, Optional.of(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)it, annotationType)));
            }
        });
    }

    private void validateAnnotation(Annotation candidate, String message, Object ... arguments) {
        Class<? extends Annotation> annotationType = candidate.annotationType();
        if (!annotationType.getName().startsWith(SPRING_DATA_PACKAGE)) {
            return;
        }
        if (this.annotationCache.containsKey(annotationType) && !this.annotationCache.get(annotationType).equals(Optional.of(candidate))) {
            throw new MappingException(String.format(message, arguments));
        }
    }

    @Override
    public Optional<String> getSpelExpression() {
        return this.value.map(Value::value);
    }

    @Override
    public boolean isTransient() {
        return this.isTransient.get();
    }

    @Override
    public boolean isIdProperty() {
        return this.isAnnotationPresent(Id.class);
    }

    @Override
    public boolean isVersionProperty() {
        return this.isAnnotationPresent(Version.class);
    }

    @Override
    public boolean isAssociation() {
        return !this.isTransient() && this.isAnnotationPresent(Reference.class);
    }

    @Override
    public boolean isWritable() {
        return !this.isTransient() && !this.isAnnotationPresent(ReadOnlyProperty.class);
    }

    @Override
    public <A extends Annotation> Optional<A> findAnnotation(Class<A> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null!");
        if (this.annotationCache != null && this.annotationCache.containsKey(annotationType)) {
            return this.annotationCache.get(annotationType);
        }
        return this.cacheAndReturn(annotationType, this.getAccessors().map(it -> it.map(inner -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)inner, (Class)annotationType))).flatMap(xva$0 -> Optionals.toStream(xva$0)).findFirst());
    }

    @Override
    public <A extends Annotation> Optional<A> findPropertyOrOwnerAnnotation(Class<A> annotationType) {
        Optional<A> annotation = this.findAnnotation(annotationType);
        return annotation.isPresent() ? annotation : this.getOwner().findAnnotation(annotationType);
    }

    private <A extends Annotation> Optional<A> cacheAndReturn(Class<? extends A> type, Optional<A> annotation) {
        if (this.annotationCache != null) {
            this.annotationCache.put(type, annotation);
        }
        return annotation;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.findAnnotation(annotationType).isPresent();
    }

    @Override
    public boolean usePropertyAccess() {
        return this.usePropertyAccess.get();
    }

    @Override
    public String toString() {
        if (this.annotationCache.isEmpty()) {
            this.populateAnnotationCache(this.getProperty());
        }
        String builder = this.annotationCache.values().stream().flatMap(it -> Optionals.toStream(it)).map(Object::toString).collect(Collectors.joining(" "));
        return builder + super.toString();
    }

    private Stream<Optional<? extends AnnotatedElement>> getAccessors() {
        return Arrays.asList(this.getGetter(), this.getSetter(), this.getField()).stream();
    }
}

