/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.util.Optional;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.util.Assert;

public class ConvertingPropertyAccessor
implements PersistentPropertyAccessor {
    private final PersistentPropertyAccessor accessor;
    private final ConversionService conversionService;

    public ConvertingPropertyAccessor(PersistentPropertyAccessor accessor, ConversionService conversionService) {
        Assert.notNull((Object)accessor, (String)"PersistentPropertyAccessor must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        this.accessor = accessor;
        this.conversionService = conversionService;
    }

    @Override
    public void setProperty(PersistentProperty<?> property, Optional<? extends Object> value) {
        this.accessor.setProperty(property, this.convertIfNecessary(value, property.getType()));
    }

    @Override
    public Optional<Object> getProperty(PersistentProperty<?> property) {
        return this.accessor.getProperty(property);
    }

    public <T> Optional<T> getProperty(PersistentProperty<?> property, Class<T> targetType) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        Assert.notNull(targetType, (String)"Target type must not be null!");
        return this.convertIfNecessary(this.getProperty(property), targetType);
    }

    @Override
    public Object getBean() {
        return this.accessor.getBean();
    }

    private <T> Optional<T> convertIfNecessary(Optional<? extends Object> source, Class<T> type) {
        return source.map(it -> type.isAssignableFrom(it.getClass()) ? it : this.conversionService.convert(it, type));
    }
}

