/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PreferredConstructor;

public class MappingInstantiationException
extends RuntimeException {
    private static final long serialVersionUID = 822211065035487628L;
    private static final String TEXT_TEMPLATE = "Failed to instantiate %s using constructor %s with arguments %s";
    private final Class<?> entityType;
    private final Constructor<?> constructor;
    private final List<Object> constructorArguments;

    public MappingInstantiationException(Optional<PersistentEntity<?, ?>> entity, List<Object> arguments, Exception cause) {
        this(entity, arguments, null, cause);
    }

    private MappingInstantiationException(Optional<PersistentEntity<?, ?>> entity, List<Object> arguments, String message, Exception cause) {
        super(MappingInstantiationException.buildExceptionMessage(entity, arguments.stream(), message), cause);
        this.entityType = entity.map(PersistentEntity::getType).orElse(null);
        this.constructor = entity.flatMap(PersistentEntity::getPersistenceConstructor).map(PreferredConstructor::getConstructor).orElse(null);
        this.constructorArguments = arguments;
    }

    private static String buildExceptionMessage(Optional<PersistentEntity<?, ?>> entity, Stream<Object> arguments, String defaultMessage) {
        return entity.map(it -> {
            Optional constructor = it.getPersistenceConstructor();
            return String.format(TEXT_TEMPLATE, it.getType().getName(), constructor.map(c -> c.getConstructor().toString()).orElse("NO_CONSTRUCTOR"), String.join((CharSequence)",", arguments.map(Object::toString).collect(Collectors.toList())));
        }).orElse(defaultMessage);
    }

    public Optional<Class<?>> getEntityType() {
        return Optional.ofNullable(this.entityType);
    }

    public Optional<Constructor<?>> getConstructor() {
        return Optional.ofNullable(this.constructor);
    }

    public List<Object> getConstructorArguments() {
        return this.constructorArguments;
    }
}

