/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core;

import java.util.Optional;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.util.Assert;

public interface EntityInformation<T, ID>
extends EntityMetadata<T> {
    public boolean isNew(T var1);

    public Optional<ID> getId(T var1);

    default public ID getRequiredId(T entity) throws IllegalArgumentException {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.getId(entity).orElseThrow(() -> new IllegalArgumentException(String.format("Could not obtain required identifier from entity %s!", entity)));
    }

    public Class<ID> getIdType();
}

