/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.Optional;
import org.springframework.core.ResolvableType;
import org.springframework.data.domain.Persistable;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class PersistableEntityInformation<T extends Persistable<ID>, ID>
extends AbstractEntityInformation<T, ID> {
    private Class<ID> idClass;

    public PersistableEntityInformation(Class<T> domainClass) {
        super(domainClass);
        this.idClass = ResolvableType.forClass(Persistable.class, domainClass).resolveGeneric(new int[]{0});
    }

    @Override
    public boolean isNew(T entity) {
        return entity.isNew();
    }

    @Override
    public Optional<ID> getId(T entity) {
        return Optional.ofNullable(entity.getId());
    }

    @Override
    public Class<ID> getIdType() {
        return this.idClass;
    }
}

