/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import org.springframework.data.annotation.Id;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectionEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    private static final Class<Id> DEFAULT_ID_ANNOTATION = Id.class;
    private Field field;

    public ReflectionEntityInformation(Class<T> domainClass) {
        this(domainClass, DEFAULT_ID_ANNOTATION);
    }

    public ReflectionEntityInformation(Class<T> domainClass, Class<? extends Annotation> annotation) {
        super(domainClass);
        Assert.notNull(annotation, (String)"Annotation must not be null!");
        ReflectionUtils.doWithFields(domainClass, field -> {
            if (field.getAnnotation(annotation) != null) {
                this.field = field;
                return;
            }
        });
        Assert.notNull((Object)this.field, () -> String.format("No field annotated with %s found!", annotation.toString()));
        ReflectionUtils.makeAccessible((Field)this.field);
    }

    @Override
    public Optional<ID> getId(Object entity) {
        return entity == null ? null : Optional.ofNullable(ReflectionUtils.getField((Field)this.field, (Object)entity));
    }

    @Override
    public Class<ID> getIdType() {
        return this.field.getType();
    }
}

