/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.repository.util.QueryExecutionConverters;

class VavrCollections {
    VavrCollections() {
    }

    public static enum FromJavaConverter implements ConditionalGenericConverter
    {
        INSTANCE{

            public java.util.Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                return CONVERTIBLE_PAIRS;
            }

            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (sourceType.isCollection() && io.vavr.collection.Map.class.isAssignableFrom(targetType.getType())) {
                    return false;
                }
                return !sourceType.isMap() || io.vavr.collection.Map.class.isAssignableFrom(targetType.getType()) || targetType.getType().equals(Traversable.class);
            }

            public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
                if (source instanceof java.util.List) {
                    return List.ofAll((Iterable)((Iterable)source));
                }
                if (source instanceof java.util.Set) {
                    return LinkedHashSet.ofAll((Iterable)((Iterable)source));
                }
                if (source instanceof Map) {
                    return LinkedHashMap.ofAll((Map)((Map)source));
                }
                return source;
            }
        };

        private static final java.util.Set<GenericConverter.ConvertiblePair> CONVERTIBLE_PAIRS;

        static {
            HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
            pairs.add(new GenericConverter.ConvertiblePair(Collection.class, Traversable.class));
            pairs.add(new GenericConverter.ConvertiblePair(Map.class, Traversable.class));
            CONVERTIBLE_PAIRS = Collections.unmodifiableSet(pairs);
        }
    }

    public static enum ToJavaConverter implements Converter<Object, Object>
    {
        INSTANCE;


        public QueryExecutionConverters.WrapperType getWrapperType() {
            return QueryExecutionConverters.WrapperType.multiValue(Traversable.class);
        }

        public Object convert(Object source) {
            if (source instanceof Seq) {
                return ((Seq)source).toJavaList();
            }
            if (source instanceof io.vavr.collection.Map) {
                return ((io.vavr.collection.Map)source).toJavaMap();
            }
            if (source instanceof Set) {
                return ((Set)source).toJavaSet();
            }
            throw new IllegalArgumentException("Unsupported Javaslang collection " + source.getClass());
        }
    }
}

