/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.querydsl;

import com.querydsl.core.types.Predicate;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.querydsl.binding.QuerydslBinderCustomizer;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.util.CastUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class QuerydslPredicateArgumentResolver
implements HandlerMethodArgumentResolver {
    private final QuerydslBindingsFactory bindingsFactory;
    private final QuerydslPredicateBuilder predicateBuilder;

    public QuerydslPredicateArgumentResolver(QuerydslBindingsFactory factory, Optional<ConversionService> conversionService) {
        this.bindingsFactory = factory;
        this.predicateBuilder = new QuerydslPredicateBuilder(conversionService.orElseGet(DefaultConversionService::new), factory.getEntityPathResolver());
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (Predicate.class.equals((Object)parameter.getParameterType())) {
            return true;
        }
        if (parameter.hasParameterAnnotation(QuerydslPredicate.class)) {
            throw new IllegalArgumentException(String.format("Parameter at position %s must be of type Predicate but was %s.", parameter.getParameterIndex(), parameter.getParameterType()));
        }
        return false;
    }

    public Predicate resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        for (Map.Entry entry : webRequest.getParameterMap().entrySet()) {
            parameters.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        Optional<Annotation> annotation = Optional.ofNullable(parameter.getParameterAnnotation(QuerydslPredicate.class));
        TypeInformation<?> domainType = QuerydslPredicateArgumentResolver.extractTypeInfo(parameter).getActualType();
        Optional<Class> bindings = annotation.map(QuerydslPredicate::bindings).map(CastUtils::cast);
        return this.predicateBuilder.getPredicate(domainType, (MultiValueMap<String, String>)parameters, bindings.map(it -> this.bindingsFactory.createBindingsFor(domainType, (Class<? extends QuerydslBinderCustomizer<?>>)it)).orElseGet(() -> this.bindingsFactory.createBindingsFor(domainType)));
    }

    static TypeInformation<?> extractTypeInfo(MethodParameter parameter) {
        Optional<Annotation> annotation = Optional.ofNullable(parameter.getParameterAnnotation(QuerydslPredicate.class));
        return annotation.filter(it -> !Object.class.equals(it.root())).map(it -> ClassTypeInformation.from(it.root())).orElseGet(() -> QuerydslPredicateArgumentResolver.detectDomainType(ClassTypeInformation.fromReturnTypeOf(parameter.getMethod())));
    }

    private static TypeInformation<?> detectDomainType(TypeInformation<?> source) {
        if (source.getTypeArguments().isEmpty()) {
            return source;
        }
        TypeInformation<?> actualType = source.getActualType();
        if (source != actualType) {
            return QuerydslPredicateArgumentResolver.detectDomainType(actualType);
        }
        if (source instanceof Iterable) {
            return source;
        }
        return QuerydslPredicateArgumentResolver.detectDomainType(source.getRequiredComponentType());
    }
}

