/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.history;

import java.time.LocalDateTime;
import java.util.Optional;

public interface RevisionMetadata<N extends Number> {
    public Optional<N> getRevisionNumber();

    default public N getRequiredRevisionNumber() {
        return (N)((Number)this.getRevisionNumber().orElseThrow(() -> new IllegalStateException(String.format("No revision number found on %s!", (Object[])this.getDelegate()))));
    }

    public Optional<LocalDateTime> getRevisionDate();

    default public LocalDateTime getRequiredRevisionDate() {
        return this.getRevisionDate().orElseThrow(() -> new IllegalStateException(String.format("No revision date found on %s!", (Object[])this.getDelegate())));
    }

    public <T> T getDelegate();
}

