/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.data.repository.config.FragmentMetadata;
import org.springframework.data.repository.config.NamedQueriesBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryFragmentConfiguration;
import org.springframework.data.repository.config.RepositoryFragmentDiscovery;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.core.support.RepositoryFragmentsFactoryBean;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

class RepositoryBeanDefinitionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryBeanDefinitionBuilder.class);
    private final BeanDefinitionRegistry registry;
    private final RepositoryConfigurationExtension extension;
    private final ResourceLoader resourceLoader;
    private final MetadataReaderFactory metadataReaderFactory;
    private final CustomRepositoryImplementationDetector implementationDetector;

    public RepositoryBeanDefinitionBuilder(BeanDefinitionRegistry registry, RepositoryConfigurationExtension extension, ResourceLoader resourceLoader, Environment environment) {
        Assert.notNull((Object)extension, (String)"RepositoryConfigurationExtension must not be null!");
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null!");
        Assert.notNull((Object)environment, (String)"Environment must not be null!");
        this.registry = registry;
        this.extension = extension;
        this.resourceLoader = resourceLoader;
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
        this.implementationDetector = new CustomRepositoryImplementationDetector(this.metadataReaderFactory, environment, resourceLoader);
    }

    public BeanDefinitionBuilder build(RepositoryConfiguration<?> configuration) {
        Assert.notNull((Object)this.registry, (String)"BeanDefinitionRegistry must not be null!");
        Assert.notNull((Object)this.resourceLoader, (String)"ResourceLoader must not be null!");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)configuration.getRepositoryFactoryBeanClassName());
        builder.getRawBeanDefinition().setSource(configuration.getSource());
        builder.addConstructorArgValue((Object)configuration.getRepositoryInterface());
        builder.addPropertyValue("queryLookupStrategyKey", configuration.getQueryLookupStrategyKey());
        builder.addPropertyValue("lazyInit", (Object)configuration.isLazyInit());
        configuration.getRepositoryBaseClassName().ifPresent(it -> builder.addPropertyValue("repositoryBaseClass", it));
        NamedQueriesBeanDefinitionBuilder definitionBuilder = new NamedQueriesBeanDefinitionBuilder(this.extension.getDefaultNamedQueryLocation());
        configuration.getNamedQueriesLocation().ifPresent(definitionBuilder::setLocations);
        builder.addPropertyValue("namedQueries", (Object)definitionBuilder.build(configuration.getSource()));
        this.registerCustomImplementation(configuration).ifPresent(it -> {
            builder.addPropertyReference("customImplementation", it);
            builder.addDependsOn(it);
        });
        BeanDefinitionBuilder fragmentsBuilder = BeanDefinitionBuilder.rootBeanDefinition(RepositoryFragmentsFactoryBean.class);
        List fragmentBeanNames = this.registerRepositoryFragmentsImplementation(configuration).map(RepositoryFragmentConfiguration::getFragmentBeanName).collect(Collectors.toList());
        fragmentsBuilder.addConstructorArgValue(fragmentBeanNames);
        builder.addPropertyValue("repositoryFragments", (Object)ParsingUtils.getSourceBeanDefinition(fragmentsBuilder, configuration.getSource()));
        return builder;
    }

    private Optional<String> registerCustomImplementation(RepositoryConfiguration<?> configuration) {
        String beanName = configuration.getImplementationBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            return Optional.of(beanName);
        }
        Optional<AbstractBeanDefinition> beanDefinition = this.implementationDetector.detectCustomImplementation(configuration);
        return beanDefinition.map(it -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registering custom repository implementation: " + configuration.getImplementationBeanName() + " " + it.getBeanClassName());
            }
            it.setSource(configuration.getSource());
            this.registry.registerBeanDefinition(beanName, (BeanDefinition)it);
            return beanName;
        });
    }

    private Stream<RepositoryFragmentConfiguration> registerRepositoryFragmentsImplementation(RepositoryConfiguration<?> configuration) {
        ClassMetadata classMetadata = this.getClassMetadata(configuration.getRepositoryInterface());
        DefaultRepositoryFragmentDiscovery fragmentConfiguration = new DefaultRepositoryFragmentDiscovery(configuration);
        return Arrays.stream(classMetadata.getInterfaceNames()).filter(it -> FragmentMetadata.isCandidate(it, this.metadataReaderFactory)).map(it -> FragmentMetadata.of(it, fragmentConfiguration)).map(it -> this.detectRepositoryFragmentConfiguration((FragmentMetadata)it, (RepositoryConfigurationSource)configuration.getConfigurationSource())).flatMap(xva$0 -> Optionals.toStream(xva$0)).peek(it -> this.potentiallyRegisterFragmentImplementation(configuration, (RepositoryFragmentConfiguration)it)).peek(it -> this.potentiallyRegisterRepositoryFragment(configuration, (RepositoryFragmentConfiguration)it));
    }

    private Optional<RepositoryFragmentConfiguration> detectRepositoryFragmentConfiguration(FragmentMetadata configuration, RepositoryConfigurationSource configurationSource) {
        String className = configuration.getFragmentImplementationClassName();
        Optional<AbstractBeanDefinition> beanDefinition = this.implementationDetector.detectCustomImplementation(className, null, configuration.getBasePackages(), configuration.getExclusions(), configurationSource::generateBeanName);
        return beanDefinition.map(bd -> new RepositoryFragmentConfiguration(configuration.getFragmentInterfaceName(), (AbstractBeanDefinition)bd));
    }

    private void potentiallyRegisterFragmentImplementation(RepositoryConfiguration<?> repositoryConfiguration, RepositoryFragmentConfiguration fragmentConfiguration) {
        String beanName = fragmentConfiguration.getImplementationBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Registering repository fragment implementation: %s %s", beanName, fragmentConfiguration.getClassName()));
        }
        fragmentConfiguration.getBeanDefinition().ifPresent(bd -> {
            bd.setSource(repositoryConfiguration.getSource());
            this.registry.registerBeanDefinition(beanName, (BeanDefinition)bd);
        });
    }

    private void potentiallyRegisterRepositoryFragment(RepositoryConfiguration<?> configuration, RepositoryFragmentConfiguration fragmentConfiguration) {
        String beanName = fragmentConfiguration.getFragmentBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registering repository fragment: " + beanName);
        }
        BeanDefinitionBuilder fragmentBuilder = BeanDefinitionBuilder.rootBeanDefinition(RepositoryFragment.class, (String)"implemented");
        fragmentBuilder.addConstructorArgValue((Object)fragmentConfiguration.getInterfaceName());
        fragmentBuilder.addConstructorArgReference(fragmentConfiguration.getImplementationBeanName());
        this.registry.registerBeanDefinition(beanName, (BeanDefinition)ParsingUtils.getSourceBeanDefinition(fragmentBuilder, configuration.getSource()));
    }

    private ClassMetadata getClassMetadata(String className) {
        try {
            return this.metadataReaderFactory.getMetadataReader(className).getClassMetadata();
        }
        catch (IOException e) {
            throw new BeanDefinitionStoreException(String.format("Cannot parse %s metadata.", className), (Throwable)e);
        }
    }

    private static class DefaultRepositoryFragmentDiscovery
    implements RepositoryFragmentDiscovery {
        private final RepositoryConfiguration<?> configuration;

        @Override
        public Streamable<TypeFilter> getExcludeFilters() {
            return this.configuration.getExcludeFilters();
        }

        @Override
        public Optional<String> getRepositoryImplementationPostfix() {
            return this.configuration.getConfigurationSource().getRepositoryImplementationPostfix();
        }

        public DefaultRepositoryFragmentDiscovery(RepositoryConfiguration<?> configuration) {
            this.configuration = configuration;
        }
    }
}

