/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.math.BigDecimal;
import java.text.Format;
import java.time.LocalDateTime;
import java.util.UUID;
import java.util.function.Predicate;
import org.springframework.data.domain.Page;
import org.springframework.data.geo.Point;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.ClassGeneratingPropertyAccessorFactory;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiatorSource;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

class AotMappingContext
extends AbstractMappingContext<BasicPersistentEntity<?, AotPersistentProperty>, AotPersistentProperty> {
    private final EntityInstantiators instantiators = new EntityInstantiators();
    private final AotAccessorFactory propertyAccessorFactory = new AotAccessorFactory();

    AotMappingContext() {
    }

    public void contribute(Class<?> entityType) {
        BasicPersistentEntity entity = (BasicPersistentEntity)this.getPersistentEntity((Class)entityType);
        if (entity != null) {
            EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
            if (instantiator instanceof EntityInstantiatorSource) {
                EntityInstantiatorSource source = (EntityInstantiatorSource)((Object)instantiator);
                source.getInstantiatorFor(entity);
            }
            this.propertyAccessorFactory.initialize(entity);
        }
    }

    @Override
    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> typeInformation) {
        Class<?> type = typeInformation.getType();
        if (type.isArray() || type.isPrimitive() || type.isEnum()) {
            return false;
        }
        Predicate<Class> isInPackage = packageMember -> type.getPackageName().startsWith(packageMember.getPackageName());
        if (isInPackage.test(UUID.class) || isInPackage.test(BigDecimal.class) || isInPackage.test(LocalDateTime.class) || isInPackage.test(Format.class) || isInPackage.test(Point.class) || isInPackage.test(Page.class) || type.getPackageName().startsWith("javax")) {
            return false;
        }
        return super.shouldCreatePersistentEntityFor(typeInformation);
    }

    @Override
    protected <T> BasicPersistentEntity<?, AotPersistentProperty> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new BasicPersistentEntity(typeInformation);
    }

    @Override
    protected AotPersistentProperty createPersistentProperty(Property property, BasicPersistentEntity<?, AotPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        return new AotPersistentProperty(property, (PersistentEntity<?, AotPersistentProperty>)owner, simpleTypeHolder);
    }

    static class AotAccessorFactory
    extends ClassGeneratingPropertyAccessorFactory {
        AotAccessorFactory() {
        }

        public void initialize(PersistentEntity<?, ?> entity) {
            if (this.isSupported(entity)) {
                this.potentiallyCreateAndRegisterPersistentPropertyAccessorClass(entity);
            }
        }
    }

    static class AotPersistentProperty
    extends AnnotationBasedPersistentProperty<AotPersistentProperty> {
        public AotPersistentProperty(Property property, PersistentEntity<?, AotPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
            super(property, owner, simpleTypeHolder);
        }

        @Override
        public boolean isAssociation() {
            return false;
        }

        @Override
        protected Association<AotPersistentProperty> createAssociation() {
            return new Association<Object>(this, null);
        }

        @Override
        public Association<AotPersistentProperty> getAssociation() {
            return new Association<Object>(this, null);
        }
    }
}

