/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.CouchbaseQueryExecutionException;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.CountFragment;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;

public abstract class AbstractN1qlBasedQuery
implements RepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractN1qlBasedQuery.class);
    protected final CouchbaseQueryMethod queryMethod;
    private final CouchbaseOperations couchbaseOperations;

    protected AbstractN1qlBasedQuery(CouchbaseQueryMethod queryMethod, CouchbaseOperations couchbaseOperations) {
        this.queryMethod = queryMethod;
        this.couchbaseOperations = couchbaseOperations;
    }

    protected abstract Statement getCount(ParameterAccessor var1, Object[] var2);

    protected abstract boolean useGeneratedCountQuery();

    protected abstract Statement getStatement(ParameterAccessor var1, Object[] var2);

    protected abstract JsonValue getPlaceholderValues(ParameterAccessor var1);

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Statement statement = this.getStatement((ParameterAccessor)accessor, parameters);
        JsonValue queryPlaceholderValues = this.getPlaceholderValues((ParameterAccessor)accessor);
        N1qlQuery query = AbstractN1qlBasedQuery.buildQuery(statement, queryPlaceholderValues, this.getCouchbaseOperations().getDefaultConsistency().n1qlConsistency());
        Statement countStatement = this.getCount((ParameterAccessor)accessor, parameters);
        N1qlQuery countQuery = AbstractN1qlBasedQuery.buildQuery(countStatement, queryPlaceholderValues, this.getCouchbaseOperations().getDefaultConsistency().n1qlConsistency());
        return this.executeDependingOnType(query, countQuery, this.queryMethod, accessor.getPageable(), this.queryMethod.isPageQuery(), this.queryMethod.isSliceQuery(), this.queryMethod.isModifyingQuery());
    }

    protected static N1qlQuery buildQuery(Statement statement, JsonValue queryPlaceholderValues, ScanConsistency scanConsistency) {
        N1qlParams n1qlParams = N1qlParams.build().consistency(scanConsistency);
        Object query = queryPlaceholderValues instanceof JsonObject && !((JsonObject)queryPlaceholderValues).isEmpty() ? N1qlQuery.parameterized((Statement)statement, (JsonObject)((JsonObject)queryPlaceholderValues), (N1qlParams)n1qlParams) : (queryPlaceholderValues instanceof JsonArray && !((JsonArray)queryPlaceholderValues).isEmpty() ? N1qlQuery.parameterized((Statement)statement, (JsonArray)((JsonArray)queryPlaceholderValues), (N1qlParams)n1qlParams) : N1qlQuery.simple((Statement)statement, (N1qlParams)n1qlParams));
        return query;
    }

    protected Object executeDependingOnType(N1qlQuery query, N1qlQuery countQuery, QueryMethod queryMethod, Pageable pageable, boolean isPage, boolean isSlice, boolean isModifying) {
        if (isModifying) {
            throw new UnsupportedOperationException("Modifying queries not yet supported");
        }
        if (isPage) {
            return this.executePaged(query, countQuery, pageable);
        }
        if (isSlice) {
            return this.executeSliced(query, countQuery, pageable);
        }
        if (queryMethod.isCollectionQuery()) {
            return this.executeCollection(query);
        }
        if (queryMethod.isQueryForEntity()) {
            return this.executeEntity(query);
        }
        if (queryMethod.isStreamQuery()) {
            return this.executeStream(query);
        }
        if (queryMethod.getReturnedObjectType().isPrimitive() && this.useGeneratedCountQuery()) {
            return this.executeSingleProjection(countQuery);
        }
        return this.executeSingleProjection(query);
    }

    private void logIfNecessary(N1qlQuery query) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing N1QL query: " + query.n1ql());
        }
    }

    protected List<?> executeCollection(N1qlQuery query) {
        this.logIfNecessary(query);
        List result = this.couchbaseOperations.findByN1QL(query, this.queryMethod.getEntityInformation().getJavaType());
        return result;
    }

    protected Object executeEntity(N1qlQuery query) {
        this.logIfNecessary(query);
        List<?> result = this.executeCollection(query);
        return result.isEmpty() ? null : result.get(0);
    }

    protected Object executeStream(N1qlQuery query) {
        this.logIfNecessary(query);
        return StreamUtils.createStreamFromIterator(this.executeCollection(query).iterator());
    }

    protected Object executePaged(N1qlQuery query, N1qlQuery countQuery, Pageable pageable) {
        Assert.notNull((Object)pageable);
        long total = 0L;
        this.logIfNecessary(countQuery);
        List<CountFragment> countResult = this.couchbaseOperations.findByN1QLProjection(countQuery, CountFragment.class);
        if (countResult != null && !countResult.isEmpty()) {
            total = countResult.get((int)0).count;
        }
        this.logIfNecessary(query);
        List result = this.couchbaseOperations.findByN1QL(query, this.queryMethod.getEntityInformation().getJavaType());
        return new PageImpl(result, pageable, total);
    }

    protected Object executeSliced(N1qlQuery query, N1qlQuery countQuery, Pageable pageable) {
        Assert.notNull((Object)pageable);
        this.logIfNecessary(query);
        List result = this.couchbaseOperations.findByN1QL(query, this.queryMethod.getEntityInformation().getJavaType());
        int pageSize = pageable.getPageSize();
        boolean hasNext = result.size() > pageSize;
        return new SliceImpl(hasNext ? result.subList(0, pageSize) : result, pageable, hasNext);
    }

    protected Object executeSingleProjection(N1qlQuery query) {
        this.logIfNecessary(query);
        List<Map> resultAsMap = this.couchbaseOperations.findByN1QLProjection(query, Map.class);
        if (resultAsMap.size() != 1) {
            throw new CouchbaseQueryExecutionException("Query returning a primitive type are expected to return exactly 1 result, got " + resultAsMap.size());
        }
        Map singleRow = resultAsMap.get(0);
        if (singleRow.size() != 1) {
            throw new CouchbaseQueryExecutionException("Query returning a simple type are expected to return a unique value, got " + singleRow.size());
        }
        Collection rowValues = singleRow.values();
        if (rowValues.size() != 1) {
            throw new CouchbaseQueryExecutionException("Query returning a simple type are expected to use a single aggregation/projection, got " + rowValues.size());
        }
        return rowValues.iterator().next();
    }

    public CouchbaseQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected CouchbaseOperations getCouchbaseOperations() {
        return this.couchbaseOperations;
    }
}

