/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import com.couchbase.client.java.repository.annotation.Id;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class BasicCouchbasePersistentEntity<T>
extends BasicPersistentEntity<T, CouchbasePersistentProperty>
implements CouchbasePersistentEntity<T>,
ApplicationContextAware {
    private final StandardEvaluationContext context = new StandardEvaluationContext();

    public BasicCouchbasePersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    protected CouchbasePersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(CouchbasePersistentProperty property) {
        if (!property.isIdProperty()) {
            return null;
        }
        if (!this.hasIdProperty()) {
            return property;
        }
        boolean currentCbId = ((CouchbasePersistentProperty)this.getIdProperty()).isAnnotationPresent(Id.class);
        boolean currentSpringId = ((CouchbasePersistentProperty)this.getIdProperty()).isAnnotationPresent(org.springframework.data.annotation.Id.class);
        boolean candidateCbId = property.isAnnotationPresent(Id.class);
        boolean candidateSpringId = property.isAnnotationPresent(org.springframework.data.annotation.Id.class);
        if (currentCbId && candidateSpringId) {
            return property;
        }
        if (currentSpringId && candidateCbId) {
            return null;
        }
        return (CouchbasePersistentProperty)super.returnPropertyIfBetterIdPropertyCandidateOrNull((PersistentProperty)property);
    }

    @Override
    public int getExpiry() {
        Document annotation = this.getType().getAnnotation(Document.class);
        if (annotation == null) {
            return 0;
        }
        long secondsShift = annotation.expiryUnit().toSeconds(annotation.expiry());
        if (secondsShift > 2592000L) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            if (annotation.expiryUnit() == TimeUnit.DAYS) {
                cal.add(5, annotation.expiry());
            } else {
                cal.add(13, (int)secondsShift);
            }
            return (int)(cal.getTimeInMillis() / 1000L);
        }
        return (int)secondsShift;
    }

    @Override
    public boolean isTouchOnRead() {
        Document annotation = this.getType().getAnnotation(Document.class);
        return annotation == null ? false : this.getExpiry() > 0 && annotation.touchOnRead();
    }
}

