/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping.event;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.util.Assert;

public class AuditingEventListener
implements ApplicationListener<BeforeConvertEvent<Object>> {
    private final ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory;

    public AuditingEventListener(ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    public void onApplicationEvent(BeforeConvertEvent<Object> event) {
        Object entity = event.getSource();
        ((IsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(entity);
    }
}

