/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public class RepositoryOperationsMapping {
    private CouchbaseOperations defaultOperations;
    private Map<String, CouchbaseOperations> byRepository = new HashMap<String, CouchbaseOperations>();
    private Map<String, CouchbaseOperations> byEntity = new HashMap<String, CouchbaseOperations>();

    public RepositoryOperationsMapping(CouchbaseOperations defaultOperations) {
        Assert.notNull((Object)defaultOperations);
        this.defaultOperations = defaultOperations;
    }

    public RepositoryOperationsMapping setDefault(CouchbaseOperations aDefault) {
        Assert.notNull((Object)aDefault);
        this.defaultOperations = aDefault;
        return this;
    }

    public RepositoryOperationsMapping map(Class<?> repositoryInterface, CouchbaseOperations couchbaseOperations) {
        this.byRepository.put(repositoryInterface.getName(), couchbaseOperations);
        return this;
    }

    public RepositoryOperationsMapping mapEntity(Class<?> entityClass, CouchbaseOperations couchbaseOperations) {
        this.byEntity.put(entityClass.getName(), couchbaseOperations);
        return this;
    }

    public CouchbaseOperations getDefault() {
        return this.defaultOperations;
    }

    public MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> getMappingContext() {
        return this.defaultOperations.getConverter().getMappingContext();
    }

    public CouchbaseOperations resolve(Class<?> repositoryInterface, Class<?> domainType) {
        CouchbaseOperations result = this.byRepository.get(repositoryInterface.getName());
        if (result != null) {
            return result;
        }
        result = this.byEntity.get(domainType.getName());
        if (result != null) {
            return result;
        }
        return this.defaultOperations;
    }
}

