/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.data.couchbase.repository.CouchbaseRepository;
import org.springframework.data.couchbase.repository.support.CouchbaseRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.w3c.dom.Element;

public class CouchbaseRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String COUCHBASE_TEMPLATE_REF = "couchbase-template-ref";
    private static final String COUCHBASE_INDEX_MANAGER_REF = "couchbase-index-manager-ref";

    public String getModuleName() {
        return "Couchbase";
    }

    protected String getModulePrefix() {
        return "couchbase";
    }

    public String getRepositoryFactoryBeanClassName() {
        return CouchbaseRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Document.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(CouchbaseRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)COUCHBASE_TEMPLATE_REF, (String)"couchbaseOperations");
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)COUCHBASE_INDEX_MANAGER_REF, (String)"indexManager");
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        builder.addDependsOn("couchbaseRepositoryOperationsMapping");
        builder.addDependsOn("couchbaseIndexManager");
        builder.addPropertyReference("couchbaseOperationsMapping", "couchbaseRepositoryOperationsMapping");
        builder.addPropertyReference("indexManager", "couchbaseIndexManager");
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return !metadata.isReactiveRepository();
    }
}

