/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.CommonOptions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.data.couchbase.repository.CouchbaseRepository;
import org.springframework.data.couchbase.repository.ReactiveCouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;

public class DynamicInvocationHandler<T>
implements InvocationHandler {
    final T target;
    final Class<?> repositoryClass;
    final CouchbaseEntityInformation<?, String> entityInformation;
    final ReactiveCouchbaseTemplate reactiveTemplate;
    CommonOptions<?> options;
    String collection;
    String scope;

    public DynamicInvocationHandler(T target, CommonOptions<?> options, String collection, String scope) {
        this.target = target;
        if (target instanceof CouchbaseRepository) {
            this.reactiveTemplate = ((CouchbaseTemplate)((CouchbaseRepository)target).getOperations()).reactive();
            this.entityInformation = ((CouchbaseRepository)target).getEntityInformation();
        } else if (target instanceof ReactiveCouchbaseRepository) {
            this.reactiveTemplate = (ReactiveCouchbaseTemplate)((ReactiveCouchbaseRepository)target).getOperations();
            this.entityInformation = ((ReactiveCouchbaseRepository)target).getEntityInformation();
        } else {
            throw new RuntimeException("Unknown target type: " + target.getClass());
        }
        this.options = options;
        this.collection = collection;
        this.scope = scope;
        this.repositoryClass = target.getClass();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if ("toString".equals(method.getName())) {
            return "proxy -> target:" + this.target;
        }
        if (method.getName().equals("withOptions")) {
            return Proxy.newProxyInstance(this.repositoryClass.getClassLoader(), this.target.getClass().getInterfaces(), new DynamicInvocationHandler<T>(this.target, (CommonOptions)args[0], this.collection, this.scope));
        }
        if (method.getName().equals("withScope")) {
            return Proxy.newProxyInstance(this.repositoryClass.getClassLoader(), this.target.getClass().getInterfaces(), new DynamicInvocationHandler<T>(this.target, this.options, this.collection, (String)args[0]));
        }
        if (method.getName().equals("withCollection")) {
            return Proxy.newProxyInstance(this.repositoryClass.getClassLoader(), this.target.getClass().getInterfaces(), new DynamicInvocationHandler<T>(this.target, this.options, (String)args[0], this.scope));
        }
        Class[] paramTypes = null;
        if (args != null) {
            paramTypes = (Class[])Arrays.stream(args).map(o -> o == null ? null : (o.getClass() == this.entityInformation.getJavaType() ? Object.class : o.getClass())).toArray(Class[]::new);
            if (method.getName().endsWith("ById") && args.length == 1) {
                paramTypes[0] = Object.class;
            }
        }
        Method theMethod = this.repositoryClass.getMethod(method.getName(), paramTypes);
        try {
            this.setThreadLocal();
            result = theMethod.invoke(this.target, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        return result;
    }

    private void setThreadLocal() {
        if (this.reactiveTemplate.getPseudoArgs() != null) {
            throw new RuntimeException("pseudoArgs not yet consumed by previous caller");
        }
        this.reactiveTemplate.setPseudoArgs(new PseudoArgs(this.scope, this.collection, this.options));
    }
}

