/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class TransportClientFactoryBean
implements FactoryBean<TransportClient>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(TransportClientFactoryBean.class);
    private String clusterNodes;
    private String clusterName;
    private Boolean clientTransportSniff;
    private Boolean clientIgnoreClusterName = Boolean.FALSE;
    private String clientPingTimeout = "5s";
    private String clientNodesSamplerInterval = "5s";
    private TransportClient client;
    private Properties properties;
    static final String COLON = ":";
    static final String COMMA = ",";

    public void destroy() throws Exception {
        try {
            logger.info("Closing elasticSearch  client");
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            logger.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public TransportClient getObject() throws Exception {
        return this.client;
    }

    public Class<TransportClient> getObjectType() {
        return TransportClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        this.buildClient();
    }

    protected void buildClient() throws Exception {
        this.client = new TransportClient(this.settings());
        Assert.hasText((String)this.clusterNodes, (String)"[Assertion failed] clusterNodes settings missing.");
        for (String clusterNode : StringUtils.split((String)this.clusterNodes, (String)COMMA)) {
            String hostName = StringUtils.substringBefore((String)clusterNode, (String)COLON);
            String port = StringUtils.substringAfter((String)clusterNode, (String)COLON);
            Assert.hasText((String)hostName, (String)"[Assertion failed] missing host name in 'clusterNodes'");
            Assert.hasText((String)port, (String)"[Assertion failed] missing port in 'clusterNodes'");
            logger.info("adding transport node : " + clusterNode);
            this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostName, Integer.valueOf(port).intValue()));
        }
        this.client.connectedNodes();
    }

    private Settings settings() {
        if (this.properties != null) {
            return ImmutableSettings.settingsBuilder().put(this.properties).build();
        }
        return ImmutableSettings.settingsBuilder().put("cluster.name", this.clusterName).put("client.transport.sniff", this.clientTransportSniff.booleanValue()).put("client.transport.ignore_cluster_name", this.clientIgnoreClusterName.booleanValue()).put("client.transport.ping_timeout", this.clientPingTimeout).put("client.transport.nodes_sampler_interval", this.clientNodesSamplerInterval).build();
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setClientTransportSniff(Boolean clientTransportSniff) {
        this.clientTransportSniff = clientTransportSniff;
    }

    public String getClientNodesSamplerInterval() {
        return this.clientNodesSamplerInterval;
    }

    public void setClientNodesSamplerInterval(String clientNodesSamplerInterval) {
        this.clientNodesSamplerInterval = clientNodesSamplerInterval;
    }

    public String getClientPingTimeout() {
        return this.clientPingTimeout;
    }

    public void setClientPingTimeout(String clientPingTimeout) {
        this.clientPingTimeout = clientPingTimeout;
    }

    public Boolean getClientIgnoreClusterName() {
        return this.clientIgnoreClusterName;
    }

    public void setClientIgnoreClusterName(Boolean clientIgnoreClusterName) {
        this.clientIgnoreClusterName = clientIgnoreClusterName;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

