/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.util.Assert;

class CriteriaQueryProcessor {
    CriteriaQueryProcessor() {
    }

    QueryBuilder createQueryFromCriteria(Criteria criteria) {
        if (criteria == null) {
            return null;
        }
        LinkedList<QueryBuilder> shouldQueryBuilderList = new LinkedList<QueryBuilder>();
        LinkedList<QueryBuilder> mustNotQueryBuilderList = new LinkedList<QueryBuilder>();
        LinkedList<QueryBuilder> mustQueryBuilderList = new LinkedList<QueryBuilder>();
        ListIterator<Criteria> chainIterator = criteria.getCriteriaChain().listIterator();
        while (chainIterator.hasNext()) {
            Criteria chainedCriteria = chainIterator.next();
            QueryBuilder queryFragmentForCriteria = this.createQueryFragmentForCriteria(chainedCriteria);
            if (queryFragmentForCriteria == null) continue;
            if (chainedCriteria.isOr()) {
                shouldQueryBuilderList.add(queryFragmentForCriteria);
                continue;
            }
            if (chainedCriteria.isNegating()) {
                mustNotQueryBuilderList.add(queryFragmentForCriteria);
                continue;
            }
            mustQueryBuilderList.add(queryFragmentForCriteria);
        }
        BoolQueryBuilder query = null;
        if (!(shouldQueryBuilderList.isEmpty() && mustNotQueryBuilderList.isEmpty() && mustQueryBuilderList.isEmpty())) {
            query = QueryBuilders.boolQuery();
            for (QueryBuilder qb : shouldQueryBuilderList) {
                query.should(qb);
            }
            for (QueryBuilder qb : mustNotQueryBuilderList) {
                query.mustNot(qb);
            }
            for (QueryBuilder qb : mustQueryBuilderList) {
                query.must(qb);
            }
        }
        return query;
    }

    private QueryBuilder createQueryFragmentForCriteria(Criteria chainedCriteria) {
        if (chainedCriteria.getQueryCriteriaEntries().isEmpty()) {
            return null;
        }
        Iterator<Criteria.CriteriaEntry> it = chainedCriteria.getQueryCriteriaEntries().iterator();
        boolean singeEntryCriteria = chainedCriteria.getQueryCriteriaEntries().size() == 1;
        String fieldName = chainedCriteria.getField().getName();
        Assert.notNull((Object)fieldName, (String)"Unknown field");
        BoolQueryBuilder query = null;
        if (singeEntryCriteria) {
            Criteria.CriteriaEntry entry = it.next();
            query = this.processCriteriaEntry(entry.getKey(), entry.getValue(), fieldName);
        } else {
            query = QueryBuilders.boolQuery();
            while (it.hasNext()) {
                Criteria.CriteriaEntry entry = it.next();
                query.must(this.processCriteriaEntry(entry.getKey(), entry.getValue(), fieldName));
            }
        }
        this.addBoost((QueryBuilder)query, chainedCriteria.getBoost());
        return query;
    }

    private QueryBuilder processCriteriaEntry(Criteria.OperationKey key, Object value, String fieldName) {
        if (value == null) {
            return null;
        }
        BoolQueryBuilder query = null;
        switch (key) {
            case EQUALS: {
                query = QueryBuilders.fieldQuery((String)fieldName, (Object)value);
                break;
            }
            case CONTAINS: {
                query = QueryBuilders.fieldQuery((String)fieldName, (String)("*" + value + "*")).analyzeWildcard(true);
                break;
            }
            case STARTS_WITH: {
                query = QueryBuilders.fieldQuery((String)fieldName, (String)(value + "*")).analyzeWildcard(true);
                break;
            }
            case ENDS_WITH: {
                query = QueryBuilders.fieldQuery((String)fieldName, (String)("*" + value)).analyzeWildcard(true);
                break;
            }
            case EXPRESSION: {
                query = QueryBuilders.queryString((String)((String)value)).field(fieldName);
                break;
            }
            case BETWEEN: {
                Object[] ranges = (Object[])value;
                query = QueryBuilders.rangeQuery((String)fieldName).from(ranges[0]).to(ranges[1]);
                break;
            }
            case FUZZY: {
                query = QueryBuilders.fuzzyQuery((String)fieldName, (String)((String)value));
                break;
            }
            case IN: {
                query = QueryBuilders.boolQuery();
                Iterable collection = (Iterable)value;
                for (Object item : collection) {
                    query.should((QueryBuilder)QueryBuilders.fieldQuery((String)fieldName, item));
                }
                break;
            }
        }
        return query;
    }

    private QueryBuilder buildNegationQuery(String fieldName, Iterator<Criteria.CriteriaEntry> it) {
        BoolQueryBuilder notQuery = QueryBuilders.boolQuery();
        while (it.hasNext()) {
            notQuery.mustNot((QueryBuilder)QueryBuilders.fieldQuery((String)fieldName, (Object)it.next().getValue()));
        }
        return notQuery;
    }

    private void addBoost(QueryBuilder query, float boost) {
        if (Float.isNaN(boost)) {
            return;
        }
        if (query instanceof BoostableQueryBuilder) {
            ((BoostableQueryBuilder)query).boost(boost);
        }
    }
}

