/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

abstract class AbstractQuery
implements Query {
    protected Pageable pageable = DEFAULT_PAGE;
    protected Sort sort;
    protected List<String> indices = new ArrayList<String>();
    protected List<String> types = new ArrayList<String>();
    protected List<String> fields = new ArrayList<String>();
    protected float minScore;

    AbstractQuery() {
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    public final <T extends Query> T setPageable(Pageable pageable) {
        Assert.notNull((Object)pageable);
        this.pageable = pageable;
        return this.addSort(pageable.getSort());
    }

    @Override
    public void addFields(String ... fields) {
        CollectionUtils.addAll(this.fields, (Object[])fields);
    }

    @Override
    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public List<String> getIndices() {
        return this.indices;
    }

    @Override
    public void addIndices(String ... indices) {
        CollectionUtils.addAll(this.indices, (Object[])indices);
    }

    @Override
    public void addTypes(String ... types) {
        CollectionUtils.addAll(this.types, (Object[])types);
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    @Override
    public final <T extends Query> T addSort(Sort sort) {
        if (sort == null) {
            return (T)this;
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return (T)this;
    }

    @Override
    public float getMinScore() {
        return this.minScore;
    }

    public void setMinScore(float minScore) {
        this.minScore = minScore;
    }
}

