/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.springframework.data.elasticsearch.core.facet.FacetRequest;
import org.springframework.data.elasticsearch.core.query.AbstractQuery;
import org.springframework.data.elasticsearch.core.query.SearchQuery;

public class NativeSearchQuery
extends AbstractQuery
implements SearchQuery {
    private QueryBuilder query;
    private FilterBuilder filter;
    private SortBuilder sort;
    private List<FacetRequest> facets;
    private HighlightBuilder.Field[] highlightFields;

    public NativeSearchQuery(QueryBuilder query) {
        this.query = query;
    }

    public NativeSearchQuery(QueryBuilder query, FilterBuilder filter) {
        this.query = query;
        this.filter = filter;
    }

    public NativeSearchQuery(QueryBuilder query, FilterBuilder filter, SortBuilder sort) {
        this.query = query;
        this.filter = filter;
        this.sort = sort;
    }

    public NativeSearchQuery(QueryBuilder query, FilterBuilder filter, SortBuilder sort, HighlightBuilder.Field[] highlightFields) {
        this.query = query;
        this.filter = filter;
        this.sort = sort;
        this.highlightFields = highlightFields;
    }

    @Override
    public QueryBuilder getQuery() {
        return this.query;
    }

    @Override
    public FilterBuilder getFilter() {
        return this.filter;
    }

    @Override
    public SortBuilder getElasticsearchSort() {
        return this.sort;
    }

    @Override
    public HighlightBuilder.Field[] getHighlightFields() {
        return this.highlightFields;
    }

    public void addFacet(FacetRequest facetRequest) {
        if (this.facets == null) {
            this.facets = new ArrayList<FacetRequest>();
        }
        this.facets.add(facetRequest);
    }

    public void setFacets(List<FacetRequest> facets) {
        this.facets = facets;
    }

    @Override
    public List<FacetRequest> getFacets() {
        return this.facets;
    }
}

