/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.facet.request;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.FacetBuilders;
import org.elasticsearch.search.facet.statistical.StatisticalFacetBuilder;
import org.springframework.data.elasticsearch.core.facet.AbstractFacetRequest;
import org.springframework.util.Assert;

public class StatisticalFacetRequest
extends AbstractFacetRequest {
    private String field;
    private String[] fields;

    public StatisticalFacetRequest(String name) {
        super(name);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFields(String ... fields) {
        this.fields = fields;
    }

    @Override
    public FacetBuilder getFacet() {
        Assert.notNull((Object)this.getName(), (String)"Facet name can't be a null !!!");
        Assert.isTrue((StringUtils.isNotBlank((String)this.field) && this.fields == null ? 1 : 0) != 0, (String)"Please select field or fields on which to build the facets !!!");
        StatisticalFacetBuilder builder = FacetBuilders.statisticalFacet((String)this.getName());
        if (ArrayUtils.isNotEmpty((Object[])this.fields)) {
            builder.fields(this.fields);
        } else {
            builder.field(this.field);
        }
        return builder;
    }
}

