/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoBoundingBoxQueryBuilder;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.elasticsearch.core.geo.GeoBox;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.util.Assert;

class CriteriaFilterProcessor {
    CriteriaFilterProcessor() {
    }

    QueryBuilder createFilterFromCriteria(Criteria criteria) {
        LinkedList<Object> fbList = new LinkedList<Object>();
        BoolQueryBuilder filter = null;
        ListIterator<Criteria> chainIterator = criteria.getCriteriaChain().listIterator();
        while (chainIterator.hasNext()) {
            BoolQueryBuilder fb = null;
            Criteria criteria2 = chainIterator.next();
            if (criteria2.isOr()) {
                fb = QueryBuilders.boolQuery();
                for (QueryBuilder f : this.createFilterFragmentForCriteria(criteria2)) {
                    fb.should(f);
                }
                fbList.add(fb);
                continue;
            }
            if (criteria2.isNegating()) {
                List<QueryBuilder> negationFilters = this.buildNegationFilter(criteria.getField().getName(), criteria.getFilterCriteriaEntries().iterator());
                if (negationFilters.isEmpty()) continue;
                fbList.addAll(negationFilters);
                continue;
            }
            fbList.addAll(this.createFilterFragmentForCriteria(criteria2));
        }
        if (!fbList.isEmpty()) {
            if (fbList.size() == 1) {
                filter = (QueryBuilder)fbList.get(0);
            } else {
                filter = QueryBuilders.boolQuery();
                for (QueryBuilder queryBuilder : fbList) {
                    filter.must(queryBuilder);
                }
            }
        }
        return filter;
    }

    private List<QueryBuilder> createFilterFragmentForCriteria(Criteria chainedCriteria) {
        Iterator<Criteria.CriteriaEntry> it = chainedCriteria.getFilterCriteriaEntries().iterator();
        LinkedList<QueryBuilder> filterList = new LinkedList<QueryBuilder>();
        String fieldName = chainedCriteria.getField().getName();
        Assert.notNull((Object)fieldName, (String)"Unknown field");
        QueryBuilder filter = null;
        while (it.hasNext()) {
            Criteria.CriteriaEntry entry = it.next();
            filter = this.processCriteriaEntry(entry.getKey(), entry.getValue(), fieldName);
            filterList.add(filter);
        }
        return filterList;
    }

    private QueryBuilder processCriteriaEntry(Criteria.OperationKey key, Object value, String fieldName) {
        if (value == null) {
            return null;
        }
        GeoBoundingBoxQueryBuilder filter = null;
        switch (key) {
            case WITHIN: {
                GeoDistanceQueryBuilder geoDistanceQueryBuilder = QueryBuilders.geoDistanceQuery((String)fieldName);
                Assert.isTrue((boolean)(value instanceof Object[]), (String)"Value of a geo distance filter should be an array of two values.");
                Object[] valArray = (Object[])value;
                Assert.noNullElements((Object[])valArray, (String)"Geo distance filter takes 2 not null elements array as parameter.");
                Assert.isTrue((valArray.length == 2 ? 1 : 0) != 0, (String)"Geo distance filter takes a 2-elements array as parameter.");
                Assert.isTrue((valArray[0] instanceof GeoPoint || valArray[0] instanceof String || valArray[0] instanceof Point ? 1 : 0) != 0, (String)"First element of a geo distance filter must be a GeoPoint, a Point or a String");
                Assert.isTrue((valArray[1] instanceof String || valArray[1] instanceof Distance ? 1 : 0) != 0, (String)"Second element of a geo distance filter must be a String or a Distance");
                StringBuilder dist = new StringBuilder();
                if (valArray[1] instanceof Distance) {
                    this.extractDistanceString((Distance)valArray[1], dist);
                } else {
                    dist.append((String)valArray[1]);
                }
                if (valArray[0] instanceof GeoPoint) {
                    GeoPoint loc = (GeoPoint)valArray[0];
                    geoDistanceQueryBuilder.lat(loc.getLat()).lon(loc.getLon()).distance(dist.toString()).geoDistance(GeoDistance.PLANE);
                } else if (valArray[0] instanceof Point) {
                    GeoPoint loc = GeoPoint.fromPoint((Point)valArray[0]);
                    geoDistanceQueryBuilder.lat(loc.getLat()).lon(loc.getLon()).distance(dist.toString()).geoDistance(GeoDistance.PLANE);
                } else {
                    String loc = (String)valArray[0];
                    if (loc.contains(",")) {
                        String[] c = loc.split(",");
                        geoDistanceQueryBuilder.lat(Double.parseDouble(c[0])).lon(Double.parseDouble(c[1])).distance(dist.toString()).geoDistance(GeoDistance.PLANE);
                    } else {
                        geoDistanceQueryBuilder.geohash(loc).distance(dist.toString()).geoDistance(GeoDistance.PLANE);
                    }
                }
                filter = geoDistanceQueryBuilder;
                break;
            }
            case BBOX: {
                filter = QueryBuilders.geoBoundingBoxQuery((String)fieldName);
                Assert.isTrue((boolean)(value instanceof Object[]), (String)"Value of a boundedBy filter should be an array of one or two values.");
                Object[] valArray = (Object[])value;
                Assert.noNullElements((Object[])valArray, (String)"Geo boundedBy filter takes a not null element array as parameter.");
                if (valArray.length == 1) {
                    this.oneParameterBBox(filter, valArray[0]);
                    break;
                }
                if (valArray.length == 2) {
                    this.twoParameterBBox(filter, valArray);
                    break;
                }
                Assert.isTrue((boolean)false, (String)"Geo distance filter takes a 1-elements array(GeoBox) or 2-elements array(GeoPoints or Strings(format lat,lon or geohash)).");
                break;
            }
        }
        return filter;
    }

    private void extractDistanceString(Distance distance, StringBuilder sb) {
        sb.append((int)distance.getValue());
        Metrics metric = (Metrics)distance.getMetric();
        switch (metric) {
            case KILOMETERS: {
                sb.append("km");
                break;
            }
            case MILES: {
                sb.append("mi");
            }
        }
    }

    private void oneParameterBBox(GeoBoundingBoxQueryBuilder filter, Object value) {
        GeoBox geoBBox;
        Assert.isTrue((value instanceof GeoBox || value instanceof Box ? 1 : 0) != 0, (String)"single-element of boundedBy filter must be type of GeoBox or Box");
        if (value instanceof Box) {
            Box sdbox = (Box)value;
            geoBBox = GeoBox.fromBox(sdbox);
        } else {
            geoBBox = (GeoBox)value;
        }
        filter.topLeft(geoBBox.getTopLeft().getLat(), geoBBox.getTopLeft().getLon());
        filter.bottomRight(geoBBox.getBottomRight().getLat(), geoBBox.getBottomRight().getLon());
    }

    private static boolean isType(Object[] array, Class clazz) {
        for (Object o : array) {
            if (clazz.isInstance(o)) continue;
            return false;
        }
        return true;
    }

    private void twoParameterBBox(GeoBoundingBoxQueryBuilder filter, Object[] values) {
        Assert.isTrue((CriteriaFilterProcessor.isType(values, GeoPoint.class) || CriteriaFilterProcessor.isType(values, String.class) ? 1 : 0) != 0, (String)" both elements of boundedBy filter must be type of GeoPoint or String(format lat,lon or geohash)");
        if (values[0] instanceof GeoPoint) {
            GeoPoint topLeft = (GeoPoint)values[0];
            GeoPoint bottomRight = (GeoPoint)values[1];
            filter.topLeft(topLeft.getLat(), topLeft.getLon());
            filter.bottomRight(bottomRight.getLat(), bottomRight.getLon());
        } else {
            String topLeft = (String)values[0];
            String bottomRight = (String)values[1];
            filter.topLeft(topLeft);
            filter.bottomRight(bottomRight);
        }
    }

    private List<QueryBuilder> buildNegationFilter(String fieldName, Iterator<Criteria.CriteriaEntry> it) {
        LinkedList<QueryBuilder> notFilterList = new LinkedList<QueryBuilder>();
        while (it.hasNext()) {
            Criteria.CriteriaEntry criteriaEntry = it.next();
            BoolQueryBuilder notFilter = QueryBuilders.boolQuery().mustNot(this.processCriteriaEntry(criteriaEntry.getKey(), criteriaEntry.getValue(), fieldName));
            notFilterList.add((QueryBuilder)notFilter);
        }
        return notFilterList;
    }
}

