/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import java.io.Serializable;
import java.util.Optional;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.util.Assert;

public class MappingElasticsearchEntityInformation<T, ID extends Serializable>
extends PersistentEntityInformation<T, ID>
implements ElasticsearchEntityInformation<T, ID> {
    private final ElasticsearchPersistentEntity<T> entityMetadata;
    private final String indexName;
    private final String type;

    public MappingElasticsearchEntityInformation(ElasticsearchPersistentEntity<T> entity) {
        this(entity, entity.getIndexName(), entity.getIndexType());
    }

    public MappingElasticsearchEntityInformation(ElasticsearchPersistentEntity<T> entity, String indexName, String type) {
        super(entity);
        Assert.notNull((Object)indexName, (String)"IndexName must not be null!");
        Assert.notNull((Object)type, (String)"IndexType must not be null!");
        this.entityMetadata = entity;
        this.indexName = indexName;
        this.type = type;
    }

    @Override
    public String getIdAttribute() {
        ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)this.entityMetadata.getIdProperty().orElseThrow(() -> new IllegalArgumentException(String.format("Unable to identify 'id' property in class %s. Make sure the 'id' property is annotated with @Id or named as 'id' or 'documentId'", this.entityMetadata.getType().getSimpleName())));
        return property.getFieldName();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Long getVersion(T entity) {
        Optional<ElasticsearchPersistentProperty> versionProperty = this.entityMetadata.getVersionProperty();
        try {
            return versionProperty.flatMap(property -> this.entityMetadata.getPropertyAccessor(entity).getProperty((PersistentProperty)property)).orElse(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load version field", e);
        }
    }

    @Override
    public String getParentId(T entity) {
        Optional<ElasticsearchPersistentProperty> parentProperty = this.entityMetadata.getParentIdProperty();
        try {
            return parentProperty.flatMap(property -> this.entityMetadata.getPropertyAccessor(entity).getProperty((PersistentProperty)property)).orElse(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load parent ID: " + e, e);
        }
    }
}

