/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.ScriptedField;
import org.springframework.data.elasticsearch.core.AbstractResultMapper;
import org.springframework.data.elasticsearch.core.DefaultEntityMapper;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.aggregation.impl.AggregatedPageImpl;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;

public class DefaultResultMapper
extends AbstractResultMapper {
    private MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;

    public DefaultResultMapper() {
        super(new DefaultEntityMapper());
    }

    public DefaultResultMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        super(new DefaultEntityMapper());
        this.mappingContext = mappingContext;
    }

    public DefaultResultMapper(EntityMapper entityMapper) {
        super(entityMapper);
    }

    public DefaultResultMapper(MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext, EntityMapper entityMapper) {
        super(entityMapper);
        this.mappingContext = mappingContext;
    }

    @Override
    public <T> AggregatedPage<T> mapResults(SearchResponse response, Class<T> clazz, Pageable pageable) {
        long totalHits = response.getHits().totalHits();
        ArrayList<Object> results = new ArrayList<Object>();
        for (SearchHit hit : response.getHits()) {
            if (hit == null) continue;
            Object result = null;
            result = StringUtils.isNotBlank((String)hit.sourceAsString()) ? (Object)this.mapEntity(hit.sourceAsString(), clazz) : (Object)this.mapEntity(hit.getFields().values(), clazz);
            this.setPersistentEntityId(result, hit.getId(), clazz);
            this.populateScriptFields(result, hit);
            results.add(result);
        }
        return new AggregatedPageImpl(results, pageable, totalHits, response.getAggregations(), response.getScrollId());
    }

    private <T> void populateScriptFields(T result, SearchHit hit) {
        if (hit.getFields() != null && !hit.getFields().isEmpty() && result != null) {
            for (Field field : result.getClass().getDeclaredFields()) {
                ScriptedField scriptedField = field.getAnnotation(ScriptedField.class);
                if (scriptedField == null) continue;
                String name = scriptedField.name().isEmpty() ? field.getName() : scriptedField.name();
                SearchHitField searchHitField = (SearchHitField)hit.getFields().get(name);
                if (searchHitField == null) continue;
                field.setAccessible(true);
                try {
                    field.set(result, searchHitField.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new ElasticsearchException("failed to set scripted field: " + name + " with value: " + searchHitField.getValue(), e);
                }
                catch (IllegalAccessException e) {
                    throw new ElasticsearchException("failed to access scripted field: " + name, e);
                }
            }
        }
    }

    private <T> T mapEntity(Collection<SearchHitField> values, Class<T> clazz) {
        return this.mapEntity(this.buildJSONFromFields(values), clazz);
    }

    private String buildJSONFromFields(Collection<SearchHitField> values) {
        JsonFactory nodeFactory = new JsonFactory();
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            JsonGenerator generator = nodeFactory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
            generator.writeStartObject();
            for (SearchHitField value : values) {
                if (value.getValues().size() > 1) {
                    generator.writeArrayFieldStart(value.getName());
                    for (Object val : value.getValues()) {
                        generator.writeObject(val);
                    }
                    generator.writeEndArray();
                    continue;
                }
                generator.writeObjectField(value.getName(), value.getValue());
            }
            generator.writeEndObject();
            generator.flush();
            return new String(stream.toByteArray(), Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public <T> T mapResult(GetResponse response, Class<T> clazz) {
        T result = this.mapEntity(response.getSourceAsString(), clazz);
        if (result != null) {
            this.setPersistentEntityId(result, response.getId(), clazz);
        }
        return result;
    }

    @Override
    public <T> LinkedList<T> mapResults(MultiGetResponse responses, Class<T> clazz) {
        LinkedList<T> list = new LinkedList<T>();
        for (MultiGetItemResponse response : responses.getResponses()) {
            if (response.isFailed() || !response.getResponse().isExists()) continue;
            T result = this.mapEntity(response.getResponse().getSourceAsString(), clazz);
            this.setPersistentEntityId(result, response.getResponse().getId(), clazz);
            list.add(result);
        }
        return list;
    }

    private <T> void setPersistentEntityId(T result, String id, Class<T> clazz) {
        if (this.mappingContext != null && clazz.isAnnotationPresent(Document.class)) {
            ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(clazz);
            Optional idProperty = persistentEntity.getIdProperty();
            idProperty.ifPresent(property -> {
                if (property.getType().isAssignableFrom(String.class)) {
                    persistentEntity.getPropertyAccessor(result).setProperty((PersistentProperty)property, Optional.ofNullable(id));
                }
            });
        }
    }
}

