/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.IOException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.search.SearchHit;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.MultiGetResultMapper;
import org.springframework.data.elasticsearch.core.SearchResultMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public interface ResultsMapper
extends SearchResultMapper,
GetResultMapper,
MultiGetResultMapper {
    public EntityMapper getEntityMapper();

    @Nullable
    default public <T> T mapEntity(String source, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)source)) {
            return null;
        }
        try {
            return this.getEntityMapper().mapToObject(source, clazz);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to map source [ " + source + "] to class " + clazz.getSimpleName(), e);
        }
    }

    @Nullable
    default public <T> T mapEntity(GetResult getResult, Class<T> type) {
        if (getResult.isSourceEmpty()) {
            return null;
        }
        String sourceString = getResult.sourceAsString();
        if (sourceString.startsWith("{\"id\":null,")) {
            sourceString = sourceString.replaceFirst("\"id\":null", "\"id\":\"" + getResult.getId() + "\"");
        }
        return this.mapEntity(sourceString, type);
    }

    @Nullable
    default public <T> T mapEntity(SearchHit searchHit, Class<T> type) {
        if (!searchHit.hasSource()) {
            return null;
        }
        String sourceString = searchHit.getSourceAsString();
        if (sourceString.startsWith("{\"id\":null,")) {
            sourceString = sourceString.replaceFirst("\"id\":null", "\"id\":\"" + searchHit.getId() + "\"");
        }
        return this.mapEntity(sourceString, type);
    }
}

