/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.data.elasticsearch.core.ScrolledPage;
import org.springframework.data.util.CloseableIterator;

abstract class StreamQueries {
    static <T> CloseableIterator<T> streamResults(final ScrolledPage<T> page, final Function<String, ScrolledPage<T>> continueFunction, final Consumer<String> clearScroll) {
        return new CloseableIterator<T>(){
            private volatile Iterator<T> currentHits;
            private volatile String scrollId;
            private volatile boolean finished;
            {
                this.currentHits = page.iterator();
                this.scrollId = page.getScrollId();
                this.finished = !this.currentHits.hasNext();
            }

            public void close() {
                try {
                    if (!this.finished && this.scrollId != null && this.currentHits != null && this.currentHits.hasNext()) {
                        clearScroll.accept(this.scrollId);
                    }
                }
                finally {
                    this.currentHits = null;
                    this.scrollId = null;
                }
            }

            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                if (this.currentHits == null || !this.currentHits.hasNext()) {
                    ScrolledPage scroll = (ScrolledPage)continueFunction.apply(this.scrollId);
                    this.currentHits = scroll.iterator();
                    this.finished = !this.currentHits.hasNext();
                    this.scrollId = scroll.getScrollId();
                }
                return this.currentHits.hasNext();
            }

            public T next() {
                if (this.hasNext()) {
                    return this.currentHits.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    private StreamQueries() {
    }
}

