/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query.parser;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.geo.GeoBox;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;

public class ElasticsearchQueryCreator
extends AbstractQueryCreator<CriteriaQuery, CriteriaQuery> {
    private final MappingContext<?, ElasticsearchPersistentProperty> context;

    public ElasticsearchQueryCreator(PartTree tree, ParameterAccessor parameters, MappingContext<?, ElasticsearchPersistentProperty> context) {
        super(tree, parameters);
        this.context = context;
    }

    public ElasticsearchQueryCreator(PartTree tree, MappingContext<?, ElasticsearchPersistentProperty> context) {
        super(tree);
        this.context = context;
    }

    protected CriteriaQuery create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        return new CriteriaQuery(this.from(part, new Criteria(path.toDotPath((Converter)ElasticsearchPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), iterator));
    }

    protected CriteriaQuery and(Part part, CriteriaQuery base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        return base.addCriteria(this.from(part, new Criteria(path.toDotPath((Converter)ElasticsearchPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), iterator));
    }

    protected CriteriaQuery or(CriteriaQuery base, CriteriaQuery query) {
        return new CriteriaQuery(base.getCriteria().or(query.getCriteria()));
    }

    protected CriteriaQuery complete(@Nullable CriteriaQuery query, Sort sort) {
        if (query == null) {
            query = new CriteriaQuery(new Criteria());
        }
        return (CriteriaQuery)query.addSort(sort);
    }

    private Criteria from(Part part, Criteria instance, Iterator<?> parameters) {
        Part.Type type = part.getType();
        Criteria criteria = instance;
        if (criteria == null) {
            criteria = new Criteria();
        }
        switch (type) {
            case TRUE: {
                return criteria.is(true);
            }
            case FALSE: {
                return criteria.is(false);
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.is(parameters.next()).not();
            }
            case REGEX: {
                return criteria.expression(parameters.next().toString());
            }
            case LIKE: 
            case STARTING_WITH: {
                return criteria.startsWith(parameters.next().toString());
            }
            case ENDING_WITH: {
                return criteria.endsWith(parameters.next().toString());
            }
            case CONTAINING: {
                return criteria.contains(parameters.next().toString());
            }
            case GREATER_THAN: {
                return criteria.greaterThan(parameters.next());
            }
            case AFTER: 
            case GREATER_THAN_EQUAL: {
                return criteria.greaterThanEqual(parameters.next());
            }
            case LESS_THAN: {
                return criteria.lessThan(parameters.next());
            }
            case BEFORE: 
            case LESS_THAN_EQUAL: {
                return criteria.lessThanEqual(parameters.next());
            }
            case BETWEEN: {
                return criteria.between(parameters.next(), parameters.next());
            }
            case IN: {
                return criteria.in(this.asArray(parameters.next()));
            }
            case NOT_IN: {
                return criteria.notIn(this.asArray(parameters.next()));
            }
            case SIMPLE_PROPERTY: 
            case WITHIN: {
                Object firstParameter = parameters.next();
                String secondParameter = null;
                if (type == Part.Type.SIMPLE_PROPERTY) {
                    if (part.getProperty().getType() != GeoPoint.class) {
                        return criteria.is(firstParameter);
                    }
                    secondParameter = ".001km";
                } else {
                    secondParameter = (String)parameters.next();
                }
                if (firstParameter instanceof GeoPoint && secondParameter instanceof String) {
                    return criteria.within((GeoPoint)firstParameter, secondParameter);
                }
                if (firstParameter instanceof Point && secondParameter instanceof Distance) {
                    return criteria.within((Point)firstParameter, (Distance)secondParameter);
                }
                if (firstParameter instanceof String && secondParameter instanceof String) {
                    return criteria.within((String)firstParameter, secondParameter);
                }
            }
            case NEAR: {
                Object firstParameter = parameters.next();
                if (firstParameter instanceof GeoBox) {
                    return criteria.boundedBy((GeoBox)firstParameter);
                }
                if (firstParameter instanceof Box) {
                    return criteria.boundedBy(GeoBox.fromBox((Box)firstParameter));
                }
                String secondParameter = (String)parameters.next();
                if (firstParameter instanceof GeoPoint && secondParameter instanceof String) {
                    return criteria.within((GeoPoint)firstParameter, secondParameter);
                }
                if (firstParameter instanceof Point && secondParameter instanceof Distance) {
                    return criteria.within((Point)firstParameter, (Distance)secondParameter);
                }
                if (!(firstParameter instanceof String) || !(secondParameter instanceof String)) break;
                return criteria.within((String)firstParameter, secondParameter);
            }
        }
        throw new InvalidDataAccessApiUsageException("Illegal criteria found '" + type + "'.");
    }

    private Object[] asArray(Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).toArray();
        }
        if (o.getClass().isArray()) {
            return (Object[])o;
        }
        return new Object[]{o};
    }
}

