/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.DeleteIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutIndexTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.index.TemplateResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;

public interface IndexOperations {
    public boolean create();

    public boolean create(Map<String, Object> var1);

    public boolean create(Map<String, Object> var1, Document var2);

    public boolean createWithMapping();

    public boolean delete();

    public boolean exists();

    public void refresh();

    public Document createMapping();

    public Document createMapping(Class<?> var1);

    default public boolean putMapping() {
        return this.putMapping(this.createMapping());
    }

    public boolean putMapping(Document var1);

    default public boolean putMapping(Class<?> clazz) {
        return this.putMapping(this.createMapping(clazz));
    }

    public Map<String, Object> getMapping();

    public Settings createSettings();

    public Settings createSettings(Class<?> var1);

    public Settings getSettings();

    public Settings getSettings(boolean var1);

    public boolean alias(AliasActions var1);

    public Map<String, Set<AliasData>> getAliases(String ... var1);

    public Map<String, Set<AliasData>> getAliasesForIndex(String ... var1);

    @Deprecated
    public boolean putTemplate(PutTemplateRequest var1);

    public boolean putIndexTemplate(PutIndexTemplateRequest var1);

    public boolean putComponentTemplate(PutComponentTemplateRequest var1);

    public boolean existsComponentTemplate(ExistsComponentTemplateRequest var1);

    public List<TemplateResponse> getComponentTemplate(GetComponentTemplateRequest var1);

    public boolean deleteComponentTemplate(DeleteComponentTemplateRequest var1);

    @Deprecated
    default public @Nullable TemplateData getTemplate(String templateName) {
        return this.getTemplate(new GetTemplateRequest(templateName));
    }

    @Deprecated
    public @Nullable TemplateData getTemplate(GetTemplateRequest var1);

    @Deprecated
    default public boolean existsTemplate(String templateName) {
        return this.existsTemplate(new ExistsTemplateRequest(templateName));
    }

    @Deprecated
    public boolean existsTemplate(ExistsTemplateRequest var1);

    default public boolean existsIndexTemplate(String templateName) {
        return this.existsIndexTemplate(new ExistsIndexTemplateRequest(templateName));
    }

    public boolean existsIndexTemplate(ExistsIndexTemplateRequest var1);

    default public List<TemplateResponse> getIndexTemplate(String templateName) {
        return this.getIndexTemplate(new GetIndexTemplateRequest(templateName));
    }

    public List<TemplateResponse> getIndexTemplate(GetIndexTemplateRequest var1);

    default public boolean deleteIndexTemplate(String templateName) {
        return this.deleteIndexTemplate(new DeleteIndexTemplateRequest(templateName));
    }

    public boolean deleteIndexTemplate(DeleteIndexTemplateRequest var1);

    @Deprecated
    default public boolean deleteTemplate(String templateName) {
        return this.deleteTemplate(new DeleteTemplateRequest(templateName));
    }

    @Deprecated
    public boolean deleteTemplate(DeleteTemplateRequest var1);

    default public List<IndexInformation> getInformation() {
        return this.getInformation(this.getIndexCoordinates());
    }

    public List<IndexInformation> getInformation(IndexCoordinates var1);

    public IndexCoordinates getIndexCoordinates();
}

