/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.ElasticsearchErrorCause;

public class SearchShardStatistics {
    private final Number failed;
    private final Number successful;
    private final Number total;
    private final @Nullable Number skipped;
    private final List<Failure> failures;

    private SearchShardStatistics(Number failed, Number successful, Number total, @Nullable Number skipped, List<Failure> failures) {
        this.failed = failed;
        this.successful = successful;
        this.total = total;
        this.skipped = skipped;
        this.failures = failures;
    }

    public static SearchShardStatistics of(Number failed, Number successful, Number total, @Nullable Number skipped, List<Failure> failures) {
        return new SearchShardStatistics(failed, successful, total, skipped, failures);
    }

    public Number getFailed() {
        return this.failed;
    }

    public Number getSuccessful() {
        return this.successful;
    }

    public Number getTotal() {
        return this.total;
    }

    public @Nullable Number getSkipped() {
        return this.skipped;
    }

    public boolean isFailed() {
        return this.failed.intValue() > 0;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public static class Failure {
        private final @Nullable String index;
        private final @Nullable String node;
        private final @Nullable String status;
        private final int shard;
        private final @Nullable Exception exception;
        private final @Nullable ElasticsearchErrorCause elasticsearchErrorCause;

        private Failure(@Nullable String index, @Nullable String node, @Nullable String status, int shard, @Nullable Exception exception, @Nullable ElasticsearchErrorCause elasticsearchErrorCause) {
            this.index = index;
            this.node = node;
            this.status = status;
            this.shard = shard;
            this.exception = exception;
            this.elasticsearchErrorCause = elasticsearchErrorCause;
        }

        public static Failure of(@Nullable String index, @Nullable String node, @Nullable String status, int shard, @Nullable Exception exception, @Nullable ElasticsearchErrorCause elasticsearchErrorCause) {
            return new Failure(index, node, status, shard, exception, elasticsearchErrorCause);
        }

        public @Nullable String getIndex() {
            return this.index;
        }

        public @Nullable String getNode() {
            return this.node;
        }

        public @Nullable String getStatus() {
            return this.status;
        }

        public @Nullable Exception getException() {
            return this.exception;
        }

        public int getShard() {
            return this.shard;
        }

        public @Nullable ElasticsearchErrorCause getElasticsearchErrorCause() {
            return this.elasticsearchErrorCause;
        }
    }
}

