/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasAction;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.util.Assert;

public class PutTemplateRequest {
    private final String name;
    private final String[] indexPatterns;
    private final @Nullable Settings settings;
    private final @Nullable Document mappings;
    final @Nullable AliasActions aliasActions;
    private final int order;
    final @Nullable Integer version;

    private PutTemplateRequest(String name, String[] indexPatterns, @Nullable Settings settings, @Nullable Document mappings, @Nullable AliasActions aliasActions, int order, @Nullable Integer version) {
        this.name = name;
        this.indexPatterns = indexPatterns;
        this.settings = settings;
        this.mappings = mappings;
        this.aliasActions = aliasActions;
        this.order = order;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String[] getIndexPatterns() {
        return this.indexPatterns;
    }

    public @Nullable Settings getSettings() {
        return this.settings;
    }

    public @Nullable Document getMappings() {
        return this.mappings;
    }

    public @Nullable AliasActions getAliasActions() {
        return this.aliasActions;
    }

    public int getOrder() {
        return this.order;
    }

    public @Nullable Integer getVersion() {
        return this.version;
    }

    public static TemplateRequestBuilder builder(String name, String ... indexPatterns) {
        return new TemplateRequestBuilder(name, indexPatterns);
    }

    public static final class TemplateRequestBuilder {
        private final String name;
        private final String[] indexPatterns;
        private @Nullable Settings settings;
        private @Nullable Document mappings;
        @Nullable AliasActions aliasActions;
        private int order = 0;
        @Nullable Integer version;

        private TemplateRequestBuilder(String name, String ... indexPatterns) {
            Assert.notNull((Object)name, (String)"name must not be null");
            Assert.notNull((Object)indexPatterns, (String)"indexPatterns must not be null");
            this.name = name;
            this.indexPatterns = indexPatterns;
        }

        public TemplateRequestBuilder withSettings(Map<String, Object> settings) {
            this.settings = new Settings(settings);
            return this;
        }

        public TemplateRequestBuilder withMappings(Document mappings) {
            this.mappings = mappings;
            return this;
        }

        public TemplateRequestBuilder withAliasActions(AliasActions aliasActions) {
            aliasActions.getActions().forEach(action -> Assert.isTrue((boolean)(action instanceof AliasAction.Add), (String)"only alias add actions are allowed in templates"));
            this.aliasActions = aliasActions;
            return this;
        }

        public TemplateRequestBuilder withOrder(int order) {
            this.order = order;
            return this;
        }

        public TemplateRequestBuilder withVersion(@Nullable Integer version) {
            this.version = version;
            return this;
        }

        public PutTemplateRequest build() {
            return new PutTemplateRequest(this.name, this.indexPatterns, this.settings, this.mappings, this.aliasActions, this.order, this.version);
        }
    }
}

