/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support.value;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.elasticsearch.repository.support.value.ElasticsearchCollectionValueToStringConverter;
import org.springframework.data.elasticsearch.repository.support.value.ElasticsearchStringValueToStringConverter;
import org.springframework.util.Assert;

public class ElasticsearchQueryValueConversionService
implements ConversionService {
    private static final Map<ConversionService, ElasticsearchQueryValueConversionService> CACHE = new ConcurrentHashMap<ConversionService, ElasticsearchQueryValueConversionService>();
    private final GenericConversionService valueConversionService = new GenericConversionService();
    private final ConversionService delegate;

    private ElasticsearchQueryValueConversionService(ConversionService delegate) {
        Assert.notNull((Object)delegate, (String)"delegated ConversionService must not be null");
        this.delegate = delegate;
        this.valueConversionService.addConverter((GenericConverter)new ElasticsearchCollectionValueToStringConverter(this));
        this.valueConversionService.addConverter((GenericConverter)new ElasticsearchStringValueToStringConverter());
    }

    public static ElasticsearchQueryValueConversionService getInstance(ConversionService conversionService) {
        return CACHE.computeIfAbsent(conversionService, ElasticsearchQueryValueConversionService::new);
    }

    public boolean canConvert(@Nullable Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(targetType, (String)"Target type to convert to cannot be null");
        return this.canConvert(TypeDescriptor.valueOf(sourceType), TypeDescriptor.valueOf(targetType));
    }

    public boolean canConvert(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.valueConversionService.canConvert(sourceType, targetType) || this.delegate.canConvert(sourceType, targetType);
    }

    public <T> @Nullable T convert(@Nullable Object source, Class<T> targetType) {
        Assert.notNull(targetType, (String)"Target type to convert to cannot be null");
        return (T)this.convert(source, TypeDescriptor.forObject((Object)source), TypeDescriptor.valueOf(targetType));
    }

    public @Nullable Object convert(@Nullable Object source, @Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (this.valueConversionService.canConvert(sourceType, targetType)) {
            return this.valueConversionService.convert(source, sourceType, targetType);
        }
        return this.delegate.convert(source, sourceType, targetType);
    }
}

