/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionFactory;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.util.Assert;

public class PartitionedRegionFactoryBean<K, V>
extends RegionFactoryBean<K, V> {
    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, DataPolicy dataPolicy) {
        Assert.isTrue((!DataPolicy.PERSISTENT_PARTITION.equals(dataPolicy) || GemfireUtils.isGemfireVersion65OrAbove() ? 1 : 0) != 0, (String)String.format("Persistent PARTITION Regions can only be used from GemFire 6.5 onwards; current version is [%1$s].", CacheFactory.getVersion()));
        if (dataPolicy == null) {
            dataPolicy = this.isPersistent() ? DataPolicy.PERSISTENT_PARTITION : DataPolicy.PARTITION;
        } else {
            Assert.isTrue((boolean)dataPolicy.withPartitioning(), (String)String.format("Data Policy '%1$s' is not supported in Partitioned Regions.", dataPolicy));
        }
        this.assertDataPolicyAndPersistentAttributesAreCompatible(dataPolicy);
        regionFactory.setDataPolicy(dataPolicy);
        this.setDataPolicy(dataPolicy);
    }

    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        DataPolicy resolvedDataPolicy = null;
        if (dataPolicy != null) {
            resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicy));
        }
        this.resolveDataPolicy(regionFactory, persistent, resolvedDataPolicy);
    }
}

