/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.function.execution.GemfireOnServersFunctionTemplate;
import org.springframework.data.gemfire.support.ListRegionsOnServerFunction;
import org.springframework.util.Assert;

public class GemfireDataSourcePostProcessor
implements BeanFactoryPostProcessor {
    private static Log logger = LogFactory.getLog(GemfireDataSourcePostProcessor.class);
    private final ClientCache cache;

    public GemfireDataSourcePostProcessor(ClientCache cache) {
        this.cache = cache;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.createClientRegions(beanFactory);
    }

    private void createClientRegions(ConfigurableListableBeanFactory beanFactory) {
        GemfireOnServersFunctionTemplate template = new GemfireOnServersFunctionTemplate((RegionService)this.cache);
        Iterable regionNames = (Iterable)template.executeAndExtract(new ListRegionsOnServerFunction(), new Object[0]);
        ClientRegionFactory clientRegionFactory = null;
        if (regionNames != null && regionNames.iterator().hasNext()) {
            clientRegionFactory = this.cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
        }
        for (String regionName : regionNames) {
            boolean createRegion = true;
            if (beanFactory.containsBean(regionName)) {
                Object existingBean = beanFactory.getBean(regionName);
                Assert.isTrue((boolean)(beanFactory.getBean(regionName) instanceof Region), (String)String.format("cannot create a ClientRegion bean named %s. A bean with this name of type %s already exists.", regionName, existingBean.getClass().getName()));
                createRegion = false;
            }
            if (createRegion) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("creating client region for %s", regionName));
                }
                beanFactory.registerSingleton(regionName, (Object)clientRegionFactory.create(regionName));
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)String.format("a region named %s is already defined", regionName));
        }
    }
}

