/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AbstractFunctionExecutionBeanDefinitionBuilder {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final FunctionExecutionConfiguration configuration;

    AbstractFunctionExecutionBeanDefinitionBuilder(FunctionExecutionConfiguration configuration) {
        Assert.notNull((Object)configuration);
        this.configuration = configuration;
    }

    BeanDefinition build(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(this.getFunctionProxyFactoryBeanClass());
        builder.addConstructorArgValue(this.configuration.getFunctionExecutionInterface());
        BeanDefinitionBuilder functionTemplateBuilder = this.getGemfireOperationsBeanDefinitionBuilder(registry);
        functionTemplateBuilder.setLazyInit(true);
        String resultCollectorRef = (String)this.configuration.getAttribute("resultCollector");
        if (StringUtils.hasText((String)resultCollectorRef)) {
            functionTemplateBuilder.addPropertyReference("resultCollector", resultCollectorRef);
        }
        AbstractBeanDefinition functionTemplate = functionTemplateBuilder.getBeanDefinition();
        String functionTemplateName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)functionTemplate, (BeanDefinitionRegistry)registry);
        builder.addConstructorArgReference(functionTemplateName);
        return builder.getBeanDefinition();
    }

    protected abstract Class<?> getFunctionProxyFactoryBeanClass();

    protected abstract BeanDefinitionBuilder getGemfireOperationsBeanDefinitionBuilder(BeanDefinitionRegistry var1);
}

