/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.function.annotation.OnMember;
import org.springframework.data.gemfire.function.annotation.OnMembers;
import org.springframework.data.gemfire.function.annotation.OnRegion;
import org.springframework.data.gemfire.function.annotation.OnServer;
import org.springframework.data.gemfire.function.annotation.OnServers;
import org.springframework.data.gemfire.function.config.FunctionExecutionComponentProvider;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfigurationSource;

abstract class AbstractFunctionExecutionConfigurationSource
implements FunctionExecutionConfigurationSource {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static Set<Class<? extends Annotation>> functionExecutionAnnotationTypes = new HashSet<Class<? extends Annotation>>();

    AbstractFunctionExecutionConfigurationSource() {
    }

    static Set<Class<? extends Annotation>> getFunctionExecutionAnnotationTypes() {
        return functionExecutionAnnotationTypes;
    }

    public Collection<ScannedGenericBeanDefinition> getCandidates(ResourceLoader loader) {
        FunctionExecutionComponentProvider scanner = new FunctionExecutionComponentProvider(this.getIncludeFilters(), functionExecutionAnnotationTypes);
        scanner.setResourceLoader(loader);
        for (TypeFilter filter : this.getExcludeFilters()) {
            scanner.addExcludeFilter(filter);
        }
        HashSet<ScannedGenericBeanDefinition> result = new HashSet<ScannedGenericBeanDefinition>();
        for (String basePackage : this.getBasePackages()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("scanning package " + basePackage));
            }
            Set components = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition definition : components) {
                result.add((ScannedGenericBeanDefinition)definition);
            }
        }
        return result;
    }

    static {
        functionExecutionAnnotationTypes.add(OnRegion.class);
        functionExecutionAnnotationTypes.add(OnServer.class);
        functionExecutionAnnotationTypes.add(OnServers.class);
        functionExecutionAnnotationTypes.add(OnMember.class);
        functionExecutionAnnotationTypes.add(OnMembers.class);
    }
}

