/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.function.config.AnnotationFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.function.config.FunctionExecutionBeanDefinitionBuilderFactory;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class FunctionExecutionBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    FunctionExecutionBeanDefinitionRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        AnnotationFunctionExecutionConfigurationSource configurationSource = new AnnotationFunctionExecutionConfigurationSource(annotationMetadata);
        this.registerBeanDefinitions(configurationSource, registry);
    }

    void registerBeanDefinitions(AbstractFunctionExecutionConfigurationSource configurationSource, BeanDefinitionRegistry registry) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        HashSet<String> functionExecutionAnnotationTypes = new HashSet<String>(AnnotationFunctionExecutionConfigurationSource.getFunctionExecutionAnnotationTypes().size());
        for (Class<? extends Annotation> annotation : AbstractFunctionExecutionConfigurationSource.getFunctionExecutionAnnotationTypes()) {
            functionExecutionAnnotationTypes.add(annotation.getName());
        }
        for (ScannedGenericBeanDefinition beanDefinition : configurationSource.getCandidates((ResourceLoader)resourceLoader)) {
            String functionExecutionAnnotation = this.getFunctionExecutionAnnotation(beanDefinition, functionExecutionAnnotationTypes);
            Assert.notNull((Object)functionExecutionAnnotation);
            String beanName = (String)beanDefinition.getMetadata().getAnnotationAttributes(functionExecutionAnnotation).get("id");
            if (!StringUtils.hasLength((String)beanName)) {
                beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
            }
            AbstractFunctionExecutionBeanDefinitionBuilder builder = FunctionExecutionBeanDefinitionBuilderFactory.newInstance(new FunctionExecutionConfiguration(beanDefinition, functionExecutionAnnotation));
            registry.registerBeanDefinition(beanName, builder.build(registry));
        }
    }

    private String getFunctionExecutionAnnotation(ScannedGenericBeanDefinition beanDefinition, Set<String> functionExecutionAnnotationTypes) {
        Set annotationTypes = beanDefinition.getMetadata().getAnnotationTypes();
        String functionExecutionAnnotation = null;
        for (String annotation : annotationTypes) {
            if (!functionExecutionAnnotationTypes.contains(annotation)) continue;
            Assert.isNull(functionExecutionAnnotation, (String)String.format("interface %s contains multiple function execution annotations: %s, %s", beanDefinition.getBeanClassName(), functionExecutionAnnotation, annotation));
            functionExecutionAnnotation = annotation;
        }
        return functionExecutionAnnotation;
    }
}

