/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;

public class ConnectionEndpointList
implements Iterable<ConnectionEndpoint> {
    private final List<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>();

    public static ConnectionEndpointList from(InetSocketAddress ... socketAddresses) {
        return ConnectionEndpointList.from(Arrays.asList(socketAddresses));
    }

    public static ConnectionEndpointList from(Iterable<InetSocketAddress> socketAddresses) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>();
        for (InetSocketAddress socketAddress : CollectionUtils.nullSafeIterable(socketAddresses)) {
            connectionEndpoints.add(ConnectionEndpoint.from(socketAddress));
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public static ConnectionEndpointList parse(int defaultPort, String ... hostsPorts) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>(hostsPorts.length);
        for (String hostPort : ArrayUtils.nullSafeArray(hostsPorts)) {
            connectionEndpoints.add(ConnectionEndpoint.parse(hostPort, defaultPort));
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public ConnectionEndpointList() {
        this(Collections.emptyList());
    }

    public ConnectionEndpointList(ConnectionEndpoint ... connectionEndpoints) {
        this(Arrays.asList(connectionEndpoints));
    }

    public ConnectionEndpointList(Iterable<ConnectionEndpoint> connectionEndpoints) {
        this.add(connectionEndpoints);
    }

    public final ConnectionEndpointList add(ConnectionEndpoint ... connectionEndpoints) {
        Collections.addAll(this.connectionEndpoints, connectionEndpoints);
        return this;
    }

    public final ConnectionEndpointList add(Iterable<ConnectionEndpoint> connectionEndpoints) {
        for (ConnectionEndpoint connectionEndpoint : CollectionUtils.nullSafeIterable(connectionEndpoints)) {
            this.connectionEndpoints.add(connectionEndpoint);
        }
        return this;
    }

    public ConnectionEndpointList findBy(String host) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>(this.size());
        for (ConnectionEndpoint connectionEndpoint : this) {
            if (!connectionEndpoint.getHost().equals(host)) continue;
            connectionEndpoints.add(connectionEndpoint);
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public ConnectionEndpointList findBy(int port) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>(this.size());
        for (ConnectionEndpoint connectionEndpoint : this) {
            if (connectionEndpoint.getPort() != port) continue;
            connectionEndpoints.add(connectionEndpoint);
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public boolean isEmpty() {
        return this.connectionEndpoints.isEmpty();
    }

    @Override
    public Iterator<ConnectionEndpoint> iterator() {
        return Collections.unmodifiableList(this.connectionEndpoints).iterator();
    }

    public int size() {
        return this.connectionEndpoints.size();
    }

    public String toString() {
        return this.connectionEndpoints.toString();
    }
}

