/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import com.gemstone.gemfire.cache.Region;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;
import org.springframework.data.gemfire.support.GemfireCache;
import org.springframework.util.Assert;

public class GemfireCacheManager
extends AbstractCacheManager {
    private com.gemstone.gemfire.cache.Cache gemfireCache;
    private Set<Region<?, ?>> regions;

    protected Collection<Cache> loadCaches() {
        if (this.regions == null) {
            Assert.state((this.gemfireCache != null ? 1 : 0) != 0, (String)"A backing GemFire Cache is required.");
            Assert.state((!this.gemfireCache.isClosed() ? 1 : 0) != 0, (String)"The GemFire Cache is closed; an open instance is required.");
            this.regions = this.gemfireCache.rootRegions();
        }
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>(this.regions.size());
        for (Region<?, ?> region : this.regions) {
            caches.add(new GemfireCache(region));
        }
        return caches;
    }

    public Cache getCache(String name) {
        Region region;
        Cache cache = super.getCache(name);
        if (cache == null && (region = this.gemfireCache.getRegion(name)) != null) {
            cache = new GemfireCache(region);
            this.addCache(cache);
        }
        return cache;
    }

    public void setCache(com.gemstone.gemfire.cache.Cache gemfireCache) {
        this.gemfireCache = gemfireCache;
    }

    public void setRegions(Set<Region<?, ?>> regions) {
        this.regions = regions;
    }
}

