/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.cache.query.QueryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class CreateDefinedIndexesApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    protected final Log logger = this.initLogger();

    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            QueryService localQueryService = this.getQueryService(event);
            if (localQueryService != null) {
                localQueryService.createDefinedIndexes();
            }
        }
        catch (Exception ignore) {
            this.logger.warn((Object)String.format("unable to create defined Indexes (if any): %1$s", ignore.getMessage()));
        }
    }

    Log initLogger() {
        return LogFactory.getLog(this.getClass());
    }

    private QueryService getQueryService(ContextRefreshedEvent event) {
        ApplicationContext localApplicationContext = event.getApplicationContext();
        return localApplicationContext.containsBean("gemfireIndexDefinitionQueryService") ? (QueryService)localApplicationContext.getBean("gemfireIndexDefinitionQueryService", QueryService.class) : null;
    }
}

