/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Formats;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.data.hadoop.store.dataset.AbstractDatasetStoreWriter;
import org.springframework.data.hadoop.store.dataset.DatasetDefinition;
import org.springframework.data.hadoop.store.dataset.DatasetRepositoryFactory;
import org.springframework.data.hadoop.store.dataset.DatasetUtils;
import org.springframework.util.Assert;

public class AvroPojoDatasetStoreWriter<T>
extends AbstractDatasetStoreWriter<T> {
    private static final Log log = LogFactory.getLog(AvroPojoDatasetStoreWriter.class);
    protected volatile DatasetWriter<T> writer;
    private final Object monitor = new Object();

    public AvroPojoDatasetStoreWriter(Class<T> entityClass, DatasetRepositoryFactory datasetRepositoryFactory) {
        this(entityClass, datasetRepositoryFactory, new DatasetDefinition(entityClass, false, Formats.AVRO.getName()));
    }

    public AvroPojoDatasetStoreWriter(Class<T> entityClass, DatasetRepositoryFactory datasetRepositoryFactory, DatasetDefinition datasetDefinition) {
        super(entityClass, datasetRepositoryFactory, datasetDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(T entity) throws IOException {
        Assert.notNull(entity, (String)"Entity to be written can't be 'null'.");
        if (!entity.getClass().equals(this.entityClass)) {
            throw new IllegalArgumentException("Entity to write is of class " + entity.getClass().getName() + ". Expected " + this.entityClass.getName());
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.writer == null) {
                if (Formats.AVRO.getName().equals(this.datasetDefinition.getFormat().getName())) {
                    Dataset dataset = DatasetUtils.getOrCreateDataset(this.datasetRepositoryFactory, this.datasetDefinition, this.entityClass, this.entityClass);
                    this.writer = dataset.newWriter();
                } else {
                    throw new StoreException("Invalid format " + this.datasetDefinition.getFormat() + " specified, you must use 'avro' with " + this.getClass().getSimpleName() + ".");
                }
            }
            if (!this.writer.isOpen()) {
                this.writer.open();
            }
        }
        this.writer.write(entity);
    }

    @Override
    public void flush() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flushing writer " + this.writer));
        }
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing writer " + this.writer));
        }
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

