/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.util.ReflectionUtils;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.support.OutputStoreObjectSupport;
import org.springframework.data.hadoop.store.support.StreamsHolder;
import org.springframework.util.ClassUtils;

public abstract class AbstractDataStreamWriter
extends OutputStoreObjectSupport {
    private static final Log log = LogFactory.getLog(AbstractDataStreamWriter.class);
    public static final int DEFAULT_MAX_OPEN_ATTEMPTS = 10;
    private int maxOpenAttempts = 10;
    private static final Object lock = new Object();

    public AbstractDataStreamWriter(Configuration configuration, Path basePath, CodecInfo codec) {
        super(configuration, basePath, codec);
    }

    public void setMaxOpenAttempts(int maxOpenAttempts) {
        this.maxOpenAttempts = maxOpenAttempts < 1 ? 1 : maxOpenAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamsHolder<OutputStream> getOutput() throws IOException {
        StreamsHolder<OutputStream> holder = new StreamsHolder<OutputStream>();
        FileSystem fs = FileSystem.get((Configuration)this.getConfiguration());
        Path p = null;
        FSDataOutputStream wout = null;
        int openAttempt = 0;
        do {
            boolean rollStrategies = false;
            try {
                p = this.getResolvedPath();
                Object object = lock;
                synchronized (object) {
                    boolean exists = fs.exists(p);
                    if (this.isAppendable() && exists) {
                        wout = fs.append(p);
                        break;
                    }
                    if (this.isOverwrite() || !exists) {
                        wout = fs.create(p, this.isOverwrite());
                        break;
                    }
                    rollStrategies = true;
                }
            }
            catch (Exception e) {
                rollStrategies = true;
            }
            if (!rollStrategies) continue;
            this.getOutputContext().rollStrategies();
        } while (++openAttempt < this.maxOpenAttempts);
        if (wout == null) {
            throw new StoreException("We've reached maxOpenAttempts=" + this.maxOpenAttempts + " to find suitable output path. Last path tried was path=[" + p + "]");
        }
        log.info((Object)("Creating output for path " + p));
        holder.setPath(p);
        if (!this.isCompressed()) {
            holder.setStream((OutputStream)wout);
        } else {
            Class clazz = ClassUtils.resolveClassName((String)this.getCodec().getCodecClass(), (ClassLoader)this.getClass().getClassLoader());
            CompressionCodec compressionCodec = (CompressionCodec)ReflectionUtils.newInstance((Class)clazz, (Configuration)this.getConfiguration());
            CompressionOutputStream out = compressionCodec.createOutputStream((OutputStream)wout);
            holder.setWrappedStream((OutputStream)wout);
            holder.setStream((OutputStream)out);
        }
        return holder;
    }

    protected long getPosition(StreamsHolder<OutputStream> holder) throws IOException {
        if (holder != null) {
            OutputStream out = holder.getStream();
            OutputStream wout = holder.getWrappedStream();
            if (out instanceof FSDataOutputStream) {
                return ((FSDataOutputStream)out).getPos();
            }
            if (wout instanceof FSDataOutputStream) {
                return ((FSDataOutputStream)wout).getPos();
            }
            return -1L;
        }
        return -1L;
    }
}

