/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.partition;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.springframework.data.hadoop.store.expression.MapExpressionMethods;
import org.springframework.data.hadoop.store.partition.AbstractPartitionStrategy;
import org.springframework.data.hadoop.store.partition.DefaultPartitionKey;
import org.springframework.data.hadoop.store.partition.PartitionKeyResolver;
import org.springframework.data.hadoop.store.partition.PartitionResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class DefaultPartitionStrategy<T>
extends AbstractPartitionStrategy<T, Map<String, Object>> {
    private static final Log log = LogFactory.getLog(DefaultPartitionStrategy.class);

    public DefaultPartitionStrategy(Expression expression) {
        this(expression, null);
    }

    public DefaultPartitionStrategy(Expression expression, StandardEvaluationContext evaluationContext) {
        super(new MapPartitionResolver(expression, (EvaluationContext)evaluationContext), new MapPartitionKeyResolver());
    }

    public DefaultPartitionStrategy(String expression) {
        this(expression, null);
    }

    public DefaultPartitionStrategy(String expression, StandardEvaluationContext evaluationContext) {
        this(expression, evaluationContext, null);
    }

    public DefaultPartitionStrategy(String expression, StandardEvaluationContext evaluationContext, ExpressionParser expressionParser) {
        super(new MapPartitionResolver(expression, evaluationContext, expressionParser), new MapPartitionKeyResolver());
    }

    private static class MapPartitionKeyResolver<T>
    implements PartitionKeyResolver<T, Map<String, Object>> {
        private MapPartitionKeyResolver() {
        }

        @Override
        public Map<String, Object> resolvePartitionKey(T entity) {
            return new DefaultPartitionKey(entity);
        }
    }

    private static class MapPartitionResolver
    implements PartitionResolver<Map<String, Object>> {
        private final Expression expression;
        private final MapExpressionMethods methods;

        public MapPartitionResolver(String expression, StandardEvaluationContext evaluationContext, ExpressionParser expressionParser) {
            if (expressionParser == null) {
                expressionParser = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
            }
            if (evaluationContext == null) {
                evaluationContext = new StandardEvaluationContext();
            }
            this.expression = expressionParser.parseExpression(expression);
            this.methods = new MapExpressionMethods(evaluationContext, true, false);
        }

        public MapPartitionResolver(Expression expression, EvaluationContext evaluationContext) {
            this.expression = expression;
            this.methods = new MapExpressionMethods(evaluationContext);
            log.info((Object)("Using expression=[" + this.expression.getExpressionString() + "]"));
        }

        @Override
        public Path resolvePath(Map<String, Object> partitionKey) {
            return new Path(this.methods.getValue(this.expression, partitionKey, String.class));
        }
    }
}

