/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.config.annotation.configurers;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.hadoop.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.data.hadoop.store.config.annotation.SpringDataStoreWriterConfigs;
import org.springframework.data.hadoop.store.config.annotation.builders.DataStoreTextWriterBuilder;
import org.springframework.data.hadoop.store.config.annotation.builders.DataStoreTextWriterConfigurer;
import org.springframework.data.hadoop.store.config.annotation.configurers.NamingStrategyConfigurer;
import org.springframework.data.hadoop.store.strategy.naming.ChainedFileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.naming.CodecFileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.naming.FileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.naming.RollingFileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.naming.StaticFileNamingStrategy;
import org.springframework.data.hadoop.store.strategy.naming.UuidFileNamingStrategy;

public class DefaultNamingStrategyConfigurer
extends AnnotationConfigurerAdapter<SpringDataStoreWriterConfigs, DataStoreTextWriterConfigurer, DataStoreTextWriterBuilder>
implements NamingStrategyConfigurer {
    private List<FileNamingStrategy> fileNamingStrategies = new ArrayList<FileNamingStrategy>();

    public void configure(DataStoreTextWriterBuilder builder) throws Exception {
        if (this.fileNamingStrategies.size() == 1) {
            builder.setFileNamingStrategy(this.fileNamingStrategies.get(0));
        } else if (this.fileNamingStrategies.size() > 1) {
            builder.setFileNamingStrategy(new ChainedFileNamingStrategy(this.fileNamingStrategies));
        }
    }

    @Override
    public NamingStrategyConfigurer name(String name, String prefix) {
        this.fileNamingStrategies.add(new StaticFileNamingStrategy(name, prefix));
        return this;
    }

    @Override
    public NamingStrategyConfigurer name(String name) {
        this.fileNamingStrategies.add(new StaticFileNamingStrategy(name));
        return this;
    }

    @Override
    public NamingStrategyConfigurer rolling() {
        this.fileNamingStrategies.add(new RollingFileNamingStrategy());
        return this;
    }

    @Override
    public NamingStrategyConfigurer codec() {
        this.fileNamingStrategies.add(new CodecFileNamingStrategy());
        return this;
    }

    @Override
    public NamingStrategyConfigurer uuid() {
        this.fileNamingStrategies.add(new UuidFileNamingStrategy());
        return this;
    }
}

