/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.expression;

import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.hadoop.store.expression.DateFormatMethodExecutor;
import org.springframework.data.hadoop.store.expression.HashListMethodExecutor;
import org.springframework.data.hadoop.store.expression.HashMethodExecutor;
import org.springframework.data.hadoop.store.expression.HashRangeMethodExecutor;
import org.springframework.data.hadoop.store.expression.PathCombiningMethodExecutor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;

public class PartitionKeyMethodResolver
extends ReflectiveMethodResolver {
    public static final String METHOD_DATEFORMAT = "dateFormat";
    public static final String METHOD_PATH = "path";
    public static final String METHOD_HASH = "hash";
    public static final String METHOD_HASHLIST = "list";
    public static final String METHOD_HASHRANGE = "range";

    public PartitionKeyMethodResolver() {
    }

    public PartitionKeyMethodResolver(boolean useDistance) {
        super(useDistance);
    }

    public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        MethodExecutor executor = super.resolve(context, (Object)targetObject, name, argumentTypes);
        if (executor != null) {
            return executor;
        }
        if (METHOD_PATH.equals(name)) {
            targetObject = PathCombiningMethodExecutor.class;
        } else if (METHOD_DATEFORMAT.equals(name)) {
            targetObject = DateFormatMethodExecutor.class;
        } else if (METHOD_HASH.equals(name)) {
            targetObject = HashMethodExecutor.class;
        } else if (METHOD_HASHLIST.equals(name)) {
            targetObject = HashListMethodExecutor.class;
        } else if (METHOD_HASHRANGE.equals(name)) {
            targetObject = HashRangeMethodExecutor.class;
        }
        return super.resolve(context, targetObject, name, argumentTypes);
    }
}

