/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.split.Split;
import org.springframework.data.hadoop.store.support.InputContext;
import org.springframework.data.hadoop.store.support.InputStoreObjectSupport;
import org.springframework.data.hadoop.store.support.StreamsHolder;
import org.springframework.util.ClassUtils;

public class AbstractDataStreamReader
extends InputStoreObjectSupport {
    private static final Log log = LogFactory.getLog(AbstractDataStreamReader.class);

    public AbstractDataStreamReader(Configuration configuration, Path basePath, CodecInfo codec) {
        super(configuration, basePath, codec);
    }

    public AbstractDataStreamReader(Configuration configuration, Path basePath, CodecInfo codec, Split split) {
        super(configuration, basePath, codec, split);
    }

    protected StreamsHolder<InputStream> getInput() throws IOException {
        Path p;
        Path inputPath = this.getPath();
        StreamsHolder<InputStream> holder = new StreamsHolder<InputStream>();
        FileSystem fs = inputPath.getFileSystem(this.getConfiguration());
        Path path = p = inputPath.isAbsolute() ? inputPath : new Path(this.getPath(), inputPath);
        if (!fs.exists(p)) {
            throw new StoreException("Path " + p + " does not exist");
        }
        if (!this.isCompressed()) {
            if (this.getSplit() == null) {
                FSDataInputStream input = fs.open(p);
                holder.setStream((InputStream)input);
            } else {
                FSDataInputStream input = fs.open(inputPath);
                input.seek(this.getSplit().getStart());
                holder.setStream((InputStream)input);
            }
        } else {
            Class clazz = ClassUtils.resolveClassName((String)this.getCodec().getCodecClass(), (ClassLoader)this.getClass().getClassLoader());
            CompressionCodec compressionCodec = (CompressionCodec)ReflectionUtils.newInstance((Class)clazz, (Configuration)this.getConfiguration());
            Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)compressionCodec);
            if (this.getSplit() == null) {
                FSDataInputStream winput = fs.open(p);
                CompressionInputStream input = compressionCodec.createInputStream((InputStream)winput, decompressor);
                holder.setWrappedStream((InputStream)winput);
                holder.setStream((InputStream)input);
            } else {
                long start = this.getSplit().getStart();
                long end = start + this.getSplit().getLength();
                log.info((Object)("SplitCompressionInputStream start=" + start + " end=" + end));
                FSDataInputStream winput = fs.open(p);
                SplitCompressionInputStream input = ((SplittableCompressionCodec)compressionCodec).createInputStream((InputStream)winput, decompressor, start, end, SplittableCompressionCodec.READ_MODE.BYBLOCK);
                holder.setWrappedStream((InputStream)winput);
                holder.setStream((InputStream)input);
            }
        }
        return holder;
    }

    protected static abstract class ReaderHelper<T, V> {
        private final StreamsHolder<InputStream> streamsHolder;
        private final InputContext inputContext;
        private T reader;
        private Seekable seekable;
        private Split inputSplit;
        private CodecInfo codec;

        protected ReaderHelper(StreamsHolder<InputStream> streamsHolder, InputContext inputContext, Split split, CodecInfo codec) {
            this.streamsHolder = streamsHolder;
            this.inputContext = inputContext;
            this.inputSplit = split;
            this.codec = codec;
            if (codec != null && streamsHolder.getStream() instanceof Seekable) {
                this.seekable = (Seekable)streamsHolder.getStream();
            }
        }

        protected abstract T createReader(InputStream var1) throws IOException;

        protected abstract V doRead(T var1) throws IOException;

        protected void init() throws IOException {
            this.reader = this.createReader(this.streamsHolder.getStream());
            if (this.codec != null && this.inputSplit != null) {
                this.inputContext.setStart(((SplitCompressionInputStream)this.streamsHolder.getStream()).getAdjustedStart());
                this.inputContext.setEnd(((SplitCompressionInputStream)this.streamsHolder.getStream()).getAdjustedEnd());
            }
        }

        protected void processReadCount(int readSize) throws IOException {
            if (this.seekable != null) {
                this.inputContext.setPosition(this.seekable.getPos());
            } else {
                this.inputContext.setPosition(this.inputContext.getPosition() + (long)readSize);
            }
        }

        protected V read() throws IOException {
            return this.doRead(this.reader);
        }

        protected T getReader() {
            return this.reader;
        }

        protected StreamsHolder<InputStream> getHolder() {
            return this.streamsHolder;
        }

        protected InputContext getContext() {
            return this.inputContext;
        }
    }
}

