/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.strategy.rollover;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.hadoop.store.strategy.rollover.AbstractRolloverStrategy;

public class SizeRolloverStrategy
extends AbstractRolloverStrategy {
    private static final Log log = LogFactory.getLog(SizeRolloverStrategy.class);
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final Pattern VALUE_PATTERN = Pattern.compile("([0-9]+([\\.,][0-9]+)?)\\s*(|K|M|G|T)B?", 2);
    private static final long DEFAULT_MAX_SIZE = 1048576000L;
    private long rolloverSize;

    public SizeRolloverStrategy() {
        this.rolloverSize = 1048576000L;
    }

    public SizeRolloverStrategy(long rolloverSize) {
        this.rolloverSize = rolloverSize;
    }

    public SizeRolloverStrategy(String rolloverSize) {
        this.rolloverSize = SizeRolloverStrategy.parseValue(rolloverSize);
    }

    @Override
    public boolean hasRolled() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking rolloverSize=" + this.rolloverSize + " against currentSize=" + this.getPosition()));
        }
        return this.rolloverSize <= this.getPosition();
    }

    public void setRolloverSize(long rolloverSize) {
        this.rolloverSize = rolloverSize;
    }

    @Override
    public void reset() {
    }

    @Override
    public SizeRolloverStrategy createInstance() {
        SizeRolloverStrategy instance = new SizeRolloverStrategy(this.rolloverSize);
        instance.setOrder(this.getOrder());
        return instance;
    }

    private static long parseValue(String string) {
        Matcher matcher = VALUE_PATTERN.matcher(string);
        if (matcher.matches()) {
            try {
                long value = NumberFormat.getNumberInstance(Locale.getDefault()).parse(matcher.group(1)).longValue();
                String units = matcher.group(3);
                if (units.equalsIgnoreCase("")) {
                    return value;
                }
                if (units.equalsIgnoreCase("K")) {
                    return value * 1024L;
                }
                if (units.equalsIgnoreCase("M")) {
                    return value * 0x100000L;
                }
                if (units.equalsIgnoreCase("G")) {
                    return value * 0x40000000L;
                }
                if (units.equalsIgnoreCase("T")) {
                    return value * 0x10000000000L;
                }
                log.error((Object)("Unable to recognize units: " + string));
                return 1048576000L;
            }
            catch (ParseException e) {
                log.error((Object)("Unable to parse: " + string), (Throwable)e);
                return 1048576000L;
            }
        }
        log.error((Object)("Unable to parse bytes: " + string));
        return 1048576000L;
    }
}

