/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.support;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.util.Assert;

public class IdleTimeoutTrigger
implements Trigger {
    private volatile long timeout;
    private final TimeUnit timeUnit;
    private volatile long initialDelay = 0L;
    private volatile long lastCompletion = Long.MIN_VALUE;
    private volatile long lastReset = Long.MIN_VALUE;

    public IdleTimeoutTrigger(long timeout) {
        this(timeout, null);
    }

    public IdleTimeoutTrigger(long timeout, TimeUnit timeUnit) {
        Assert.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"timeout must not be negative");
        this.timeUnit = timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS;
        this.timeout = this.timeUnit.toMillis(timeout);
    }

    public Date nextExecutionTime(TriggerContext triggerContext) {
        if (triggerContext.lastScheduledExecutionTime() == null) {
            return new Date(System.currentTimeMillis() + this.initialDelay);
        }
        if (this.lastReset > this.lastCompletion) {
            this.lastCompletion = triggerContext.lastCompletionTime().getTime();
            return new Date(this.lastReset + this.timeout);
        }
        this.lastCompletion = triggerContext.lastCompletionTime().getTime();
        return new Date(this.lastCompletion + this.timeout);
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = this.timeUnit.toMillis(initialDelay);
    }

    public void reset() {
        this.lastReset = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.initialDelay ^ this.initialDelay >>> 32);
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdleTimeoutTrigger other = (IdleTimeoutTrigger)obj;
        if (this.initialDelay != other.initialDelay) {
            return false;
        }
        return this.timeout == other.timeout;
    }
}

